/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters;

import java.util.concurrent.ExecutorService;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters.AlarmExists;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters.CompositeAlarmExists;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters.DescribeAlarmsFunction;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.Waiter;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterExecutorServiceFactory;

public class AmazonCloudWatchWaiters {
    private final AmazonCloudWatch client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonCloudWatchWaiters");

    @SdkInternalApi
    public AmazonCloudWatchWaiters(AmazonCloudWatch client) {
        this.client = client;
    }

    public Waiter<DescribeAlarmsRequest> alarmExists() {
        return new WaiterBuilder<DescribeAlarmsRequest, DescribeAlarmsResult>().withSdkFunction(new DescribeAlarmsFunction(this.client)).withAcceptors(new AlarmExists.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAlarmsRequest> compositeAlarmExists() {
        return new WaiterBuilder<DescribeAlarmsRequest, DescribeAlarmsResult>().withSdkFunction(new DescribeAlarmsFunction(this.client)).withAcceptors(new CompositeAlarmExists.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

