/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import software.amazon.kinesis.shaded.com.amazonaws.client.AwsAsyncClientParams;
import software.amazon.kinesis.shaded.com.amazonaws.handlers.AsyncHandler;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsAsync;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsAsyncClientBuilder;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetRecordsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListStreamsResult;

@ThreadSafe
public class AmazonDynamoDBStreamsAsyncClient
extends AmazonDynamoDBStreamsClient
implements AmazonDynamoDBStreamsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonDynamoDBStreamsAsyncClientBuilder asyncBuilder() {
        return AmazonDynamoDBStreamsAsyncClientBuilder.standard();
    }

    AmazonDynamoDBStreamsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonDynamoDBStreamsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request) {
        return this.describeStreamAsync(request, null);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        final DescribeStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result = null;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.executeDescribeStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(GetRecordsRequest request) {
        return this.getRecordsAsync(request, null);
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(GetRecordsRequest request, final AsyncHandler<GetRecordsRequest, GetRecordsResult> asyncHandler) {
        final GetRecordsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                GetRecordsResult result = null;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.executeGetRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(GetShardIteratorRequest request) {
        return this.getShardIteratorAsync(request, null);
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(GetShardIteratorRequest request, final AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        final GetShardIteratorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                GetShardIteratorResult result = null;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.executeGetShardIterator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request) {
        return this.listStreamsAsync(request, null);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        final ListStreamsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result = null;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.executeListStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

