/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.ArrayList;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.NotThreadSafe;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTransactionWriteExpression;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ReturnValuesOnConditionCheckFailure;

@NotThreadSafe
public class TransactionWriteRequest {
    private final List<TransactionWriteOperation> transactionWriteOperations = new ArrayList<TransactionWriteOperation>();
    private String idempotencyToken;

    public TransactionWriteRequest addPut(Object object) {
        return this.addPut(object, null);
    }

    public TransactionWriteRequest addPut(Object object, DynamoDBTransactionWriteExpression transactionWriteExpression) {
        return this.addPut(object, transactionWriteExpression, null);
    }

    public TransactionWriteRequest addPut(Object object, DynamoDBTransactionWriteExpression transactionWriteExpression, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.transactionWriteOperations.add(new TransactionWriteOperation(object, TransactionWriteOperationType.Put, transactionWriteExpression, returnValuesOnConditionCheckFailure));
        return this;
    }

    public TransactionWriteRequest addUpdate(Object object) {
        return this.addUpdate(object, null);
    }

    public TransactionWriteRequest addUpdate(Object object, DynamoDBTransactionWriteExpression transactionWriteExpression) {
        return this.addUpdate(object, transactionWriteExpression, null);
    }

    public TransactionWriteRequest addUpdate(Object object, DynamoDBTransactionWriteExpression transactionWriteExpression, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.transactionWriteOperations.add(new TransactionWriteOperation(object, TransactionWriteOperationType.Update, transactionWriteExpression, returnValuesOnConditionCheckFailure));
        return this;
    }

    public TransactionWriteRequest addDelete(Object key) {
        return this.addDelete(key, null);
    }

    public TransactionWriteRequest addDelete(Object key, DynamoDBTransactionWriteExpression transactionWriteExpression) {
        return this.addDelete(key, transactionWriteExpression, null);
    }

    public TransactionWriteRequest addDelete(Object key, DynamoDBTransactionWriteExpression transactionWriteExpression, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.transactionWriteOperations.add(new TransactionWriteOperation(key, TransactionWriteOperationType.Delete, transactionWriteExpression, returnValuesOnConditionCheckFailure));
        return this;
    }

    public TransactionWriteRequest addConditionCheck(Object key, DynamoDBTransactionWriteExpression transactionWriteExpression) {
        return this.addConditionCheck(key, transactionWriteExpression, null);
    }

    public TransactionWriteRequest addConditionCheck(Object key, DynamoDBTransactionWriteExpression transactionWriteExpression, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.transactionWriteOperations.add(new TransactionWriteOperation(key, TransactionWriteOperationType.ConditionCheck, transactionWriteExpression, returnValuesOnConditionCheckFailure));
        return this;
    }

    public TransactionWriteRequest withIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
        return this;
    }

    public List<TransactionWriteOperation> getTransactionWriteOperations() {
        return this.transactionWriteOperations;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public static enum TransactionWriteOperationType {
        Put,
        Update,
        ConditionCheck,
        Delete;

    }

    public static class TransactionWriteOperation {
        private Object object;
        private TransactionWriteOperationType transactionWriteOperationType;
        private DynamoDBTransactionWriteExpression dynamoDBTransactionWriteExpression;
        private ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure;

        public TransactionWriteOperation(Object object, TransactionWriteOperationType transactionWriteOperationType, DynamoDBTransactionWriteExpression dynamoDBTransactionWriteExpression, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.object = object;
            this.transactionWriteOperationType = transactionWriteOperationType;
            this.dynamoDBTransactionWriteExpression = dynamoDBTransactionWriteExpression;
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        public Object getObject() {
            return this.object;
        }

        public TransactionWriteOperationType getTransactionWriteOperationType() {
            return this.transactionWriteOperationType;
        }

        public DynamoDBTransactionWriteExpression getDynamoDBTransactionWriteExpression() {
            return this.dynamoDBTransactionWriteExpression;
        }

        public ReturnValuesOnConditionCheckFailure getReturnValuesOnConditionCheckFailure() {
            return this.returnValuesOnConditionCheckFailure;
        }
    }
}

