/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.SSUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.util.DateUtils;

public class CalendarSetUnmarshaller
extends SSUnmarshaller {
    private static final CalendarSetUnmarshaller INSTANCE = new CalendarSetUnmarshaller();

    public static CalendarSetUnmarshaller instance() {
        return INSTANCE;
    }

    private CalendarSetUnmarshaller() {
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        HashSet<Calendar> result = new HashSet<Calendar>();
        for (String s : value.getSS()) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(DateUtils.parseISO8601Date(s));
            result.add(cal);
        }
        return result;
    }
}

