/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.SUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;

public class CustomUnmarshaller
extends SUnmarshaller {
    private final Class<?> targetClass;
    private final Class<? extends DynamoDBMarshaller<?>> unmarshallerClass;

    public CustomUnmarshaller(Class<?> targetClass, Class<? extends DynamoDBMarshaller<?>> unmarshallerClass) {
        this.targetClass = targetClass;
        this.unmarshallerClass = unmarshallerClass;
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        DynamoDBMarshaller unmarshaller = CustomUnmarshaller.createUnmarshaller(this.unmarshallerClass);
        return unmarshaller.unmarshall(this.targetClass, value.getS());
    }

    private static DynamoDBMarshaller createUnmarshaller(Class<?> clazz) {
        try {
            return (DynamoDBMarshaller)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
    }
}

