/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document;

import java.util.List;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import software.amazon.kinesis.shaded.com.amazonaws.regions.Regions;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.BatchGetItemOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.TableCollection;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.BatchGetItemApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.BatchWriteItemApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.ListTablesApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.BatchGetItemImpl;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.BatchWriteItemImpl;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.ListTablesImpl;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.BatchGetItemSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.BatchWriteItemSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.ListTablesSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.WriteRequest;

@ThreadSafe
public class DynamoDB
implements ListTablesApi,
BatchGetItemApi,
BatchWriteItemApi {
    private final AmazonDynamoDB client;
    private final ListTablesImpl listTablesDelegate;
    private final BatchGetItemImpl batchGetItemDelegate;
    private final BatchWriteItemImpl batchWriteItemDelegate;

    public DynamoDB(AmazonDynamoDB client) {
        if (client == null) {
            throw new IllegalArgumentException();
        }
        this.client = client;
        this.listTablesDelegate = new ListTablesImpl(client);
        this.batchGetItemDelegate = new BatchGetItemImpl(client);
        this.batchWriteItemDelegate = new BatchWriteItemImpl(client);
    }

    public DynamoDB(Regions regionEnum) {
        this((AmazonDynamoDB)new AmazonDynamoDBClient().withRegion(regionEnum));
    }

    public Table getTable(String tableName) {
        return new Table(this.client, tableName);
    }

    public Table createTable(CreateTableRequest req) {
        CreateTableResult result = this.client.createTable(req);
        return new Table(this.client, req.getTableName(), result.getTableDescription());
    }

    public Table createTable(String tableName, List<KeySchemaElement> keySchema, List<AttributeDefinition> attributeDefinitions, ProvisionedThroughput provisionedThroughput) {
        return this.createTable(new CreateTableRequest().withTableName(tableName).withKeySchema(keySchema).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public TableCollection<ListTablesResult> listTables() {
        return this.listTablesDelegate.listTables();
    }

    @Override
    public TableCollection<ListTablesResult> listTables(String exclusiveStartTableName) {
        return this.listTablesDelegate.listTables(exclusiveStartTableName);
    }

    @Override
    public TableCollection<ListTablesResult> listTables(String exclusiveStartTableName, int maxResultSize) {
        return this.listTablesDelegate.listTables(exclusiveStartTableName, maxResultSize);
    }

    @Override
    public TableCollection<ListTablesResult> listTables(int maxResultSize) {
        return this.listTablesDelegate.listTables(maxResultSize);
    }

    @Override
    public TableCollection<ListTablesResult> listTables(ListTablesSpec spec) {
        return this.listTablesDelegate.listTables(spec);
    }

    @Override
    public BatchGetItemOutcome batchGetItem(ReturnConsumedCapacity returnConsumedCapacity, TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.batchGetItemDelegate.batchGetItem(returnConsumedCapacity, tableKeysAndAttributes);
    }

    @Override
    public BatchGetItemOutcome batchGetItem(TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.batchGetItemDelegate.batchGetItem(tableKeysAndAttributes);
    }

    @Override
    public BatchGetItemOutcome batchGetItem(BatchGetItemSpec spec) {
        return this.batchGetItemDelegate.batchGetItem(spec);
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(ReturnConsumedCapacity returnConsumedCapacity, Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.batchGetItemDelegate.batchGetItemUnprocessed(returnConsumedCapacity, unprocessedKeys);
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.batchGetItemDelegate.batchGetItemUnprocessed(unprocessedKeys);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(TableWriteItems ... tableWriteItems) {
        return this.batchWriteItemDelegate.batchWriteItem(tableWriteItems);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(BatchWriteItemSpec spec) {
        return this.batchWriteItemDelegate.batchWriteItem(spec);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItemUnprocessed(Map<String, List<WriteRequest>> unprocessedItems) {
        return this.batchWriteItemDelegate.batchWriteItemUnprocessed(unprocessedItems);
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

