/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.BatchGetItemOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.BatchGetItemApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.BatchGetItemSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;

public class BatchGetItemImpl
implements BatchGetItemApi {
    private final AmazonDynamoDB client;

    public BatchGetItemImpl(AmazonDynamoDB client) {
        this.client = client;
    }

    @Override
    public BatchGetItemOutcome batchGetItem(ReturnConsumedCapacity returnConsumedCapacity, TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.doBatchGetItem(new BatchGetItemSpec().withReturnConsumedCapacity(returnConsumedCapacity).withTableKeyAndAttributes(tableKeysAndAttributes));
    }

    @Override
    public BatchGetItemOutcome batchGetItem(TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.doBatchGetItem(new BatchGetItemSpec().withTableKeyAndAttributes(tableKeysAndAttributes));
    }

    @Override
    public BatchGetItemOutcome batchGetItem(BatchGetItemSpec spec) {
        return this.doBatchGetItem(spec);
    }

    private BatchGetItemOutcome doBatchGetItem(BatchGetItemSpec spec) {
        Collection<TableKeysAndAttributes> tableKeysAndAttributesCol = spec.getTableKeysAndAttributes();
        Map<String, KeysAndAttributes> requestItems = spec.getUnprocessedKeys();
        requestItems = requestItems == null || requestItems.size() == 0 ? new LinkedHashMap<String, KeysAndAttributes>() : new LinkedHashMap<String, KeysAndAttributes>(requestItems);
        if (tableKeysAndAttributesCol != null) {
            for (TableKeysAndAttributes tableKeysAndAttributes : tableKeysAndAttributesCol) {
                Set<String> attrNames = tableKeysAndAttributes.getAttributeNames();
                List<PrimaryKey> pks = tableKeysAndAttributes.getPrimaryKeys();
                ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(pks.size());
                for (PrimaryKey pk : pks) {
                    keys.add(InternalUtils.toAttributeValueMap(pk));
                }
                KeysAndAttributes keysAndAttrs = new KeysAndAttributes().withAttributesToGet(attrNames).withConsistentRead(tableKeysAndAttributes.isConsistentRead()).withKeys(keys).withProjectionExpression(tableKeysAndAttributes.getProjectionExpression()).withExpressionAttributeNames(tableKeysAndAttributes.getNameMap());
                requestItems.put(tableKeysAndAttributes.getTableName(), keysAndAttrs);
            }
        }
        BatchGetItemRequest req = ((BatchGetItemRequest)spec.getRequest()).withRequestItems(requestItems);
        BatchGetItemResult result = this.client.batchGetItem(req);
        return new BatchGetItemOutcome(result);
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(ReturnConsumedCapacity returnConsumedCapacity, Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.doBatchGetItem(new BatchGetItemSpec().withReturnConsumedCapacity(returnConsumedCapacity).withUnprocessedKeys(unprocessedKeys));
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.doBatchGetItem(new BatchGetItemSpec().withUnprocessedKeys(unprocessedKeys));
    }
}

