/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.ValueTransformer;
import software.amazon.kinesis.shaded.com.amazonaws.util.BinaryUtils;

public class ItemValueConformer
extends ValueTransformer {
    @Override
    public Object transform(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Number) {
            return InternalUtils.toBigDecimal((Number)value);
        }
        if (value instanceof byte[]) {
            return value;
        }
        if (value instanceof ByteBuffer) {
            return BinaryUtils.copyBytesFrom((ByteBuffer)value);
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.size() == 0) {
                return value;
            }
            Object element = set.iterator().next();
            if (element instanceof String) {
                return value;
            }
            if (element instanceof BigDecimal) {
                return value;
            }
            if (element instanceof Number) {
                Set in = (Set)value;
                LinkedHashSet<BigDecimal> out = new LinkedHashSet<BigDecimal>(set.size());
                for (Number n : in) {
                    out.add(InternalUtils.toBigDecimal(n));
                }
                return out;
            }
            if (element instanceof byte[]) {
                return value;
            }
            if (element instanceof ByteBuffer) {
                Set bs = (Set)value;
                LinkedHashSet<byte[]> out = new LinkedHashSet<byte[]>(bs.size());
                for (ByteBuffer bb : bs) {
                    out.add(BinaryUtils.copyBytesFrom(bb));
                }
                return out;
            }
            throw new UnsupportedOperationException("element type: " + element.getClass());
        }
        if (value instanceof List) {
            List in = (List)value;
            if (in.size() == 0) {
                return in;
            }
            ArrayList<Object> out = new ArrayList<Object>();
            for (Object v : in) {
                out.add(this.transform(v));
            }
            return out;
        }
        if (value instanceof Map) {
            Map in = (Map)value;
            if (in.size() == 0) {
                return in;
            }
            LinkedHashMap out = new LinkedHashMap(in.size());
            for (Map.Entry e : in.entrySet()) {
                out.put(e.getKey(), this.transform(e.getValue()));
            }
            return out;
        }
        throw new UnsupportedOperationException("value type: " + value.getClass());
    }
}

