/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Collection;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ItemCollection;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.KeyConditions;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.QueryFilter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.QueryApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.QueryCollection;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Condition;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.QueryRequest;

public class QueryImpl
extends AbstractImpl
implements QueryApi {
    public QueryImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKey) {
        return this.doQuery(new QuerySpec().withHashKey(new KeyAttribute(hashKeyName, hashKey)));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withQueryFilters(queryFilters));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withFilterExpression(filterExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withFilterExpression(filterExpression).withProjectionExpression(projectionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.doQuery(spec);
    }

    protected ItemCollection<QueryOutcome> doQuery(QuerySpec spec) {
        Collection<KeyAttribute> startKey;
        Collection<QueryFilter> filters;
        RangeKeyCondition rangeKeyCond;
        String tableName = this.getTable().getTableName();
        QueryRequest req = ((QueryRequest)spec.getRequest()).withTableName(tableName);
        KeyAttribute hashKey = spec.getHashKey();
        if (hashKey != null) {
            this.addHashKeyCondition(req, hashKey);
        }
        if ((rangeKeyCond = spec.getRangeKeyCondition()) != null) {
            this.addRangeKeyCondition(req, rangeKeyCond);
        }
        if ((filters = spec.getQueryFilters()) != null) {
            req.setQueryFilter(InternalUtils.toAttributeConditionMap(filters));
        }
        if ((startKey = spec.getExclusiveStartKey()) != null) {
            req.setExclusiveStartKey(InternalUtils.toAttributeValueMap(startKey));
        }
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        return new QueryCollection(this.getClient(), spec);
    }

    private void addHashKeyCondition(QueryRequest req, KeyAttribute hashKey) {
        this.addKeyCondition(req, hashKey.getName(), ComparisonOperator.EQ, InternalUtils.toAttributeValue(hashKey.getValue()));
    }

    private void addRangeKeyCondition(QueryRequest req, RangeKeyCondition rangeKeyCond) {
        KeyConditions keyCond = rangeKeyCond.getKeyCondition();
        if (keyCond == null) {
            throw new IllegalArgumentException("key condition not specified in range key condition");
        }
        Object[] values = rangeKeyCond.getValues();
        if (values == null) {
            throw new IllegalArgumentException("key condition values not specified in range key condition");
        }
        this.addKeyCondition(req, rangeKeyCond.getAttrName(), keyCond.toComparisonOperator(), InternalUtils.toAttributeValues(values));
    }

    private void addKeyCondition(QueryRequest req, String keyName, ComparisonOperator comparison, AttributeValue ... values) {
        Map<String, Condition> currentConditions = req.getKeyConditions();
        Condition currentCondition = currentConditions == null ? null : currentConditions.get(keyName);
        Condition newCondition = new Condition().withComparisonOperator(comparison).withAttributeValueList(values);
        if (currentCondition == null) {
            req.addKeyConditionsEntry(keyName, newCondition);
        } else if (!currentCondition.equals(newCondition)) {
            throw new IllegalArgumentException("a different condition was specified for '" + keyName + "' in the query spec and the query request");
        }
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }
}

