/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.QueryRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.QueryResult;

class QueryPage
extends Page<Item, QueryOutcome> {
    private final AmazonDynamoDB client;
    private final QuerySpec spec;
    private final QueryRequest request;
    private final int index;
    private final Map<String, AttributeValue> lastEvaluatedKey;

    public QueryPage(AmazonDynamoDB client, QuerySpec spec, QueryRequest request, int index, QueryOutcome outcome) {
        super(Collections.unmodifiableList(InternalUtils.toItemList(outcome.getQueryResult().getItems())), outcome);
        this.client = client;
        this.spec = spec;
        this.request = request;
        this.index = index;
        Integer max = spec.getMaxResultSize();
        QueryResult result = outcome.getQueryResult();
        List<Map<String, AttributeValue>> ilist = result.getItems();
        int size = ilist == null ? 0 : ilist.size();
        this.lastEvaluatedKey = max != null && index + size > max ? null : result.getLastEvaluatedKey();
    }

    @Override
    public boolean hasNextPage() {
        if (this.lastEvaluatedKey == null) {
            return false;
        }
        Integer max = this.spec.getMaxResultSize();
        if (max == null) {
            return true;
        }
        return this.nextRequestLimit(max) > 0;
    }

    private int nextRequestLimit(int max) {
        int nextIndex = this.index + this.size();
        return InternalUtils.minimum(max - nextIndex, this.spec.getMaxPageSize());
    }

    @Override
    public Page<Item, QueryOutcome> nextPage() {
        if (this.lastEvaluatedKey == null) {
            throw new NoSuchElementException("No more pages");
        }
        Integer max = this.spec.getMaxResultSize();
        if (max != null) {
            int nextLimit = this.nextRequestLimit(max);
            if (nextLimit == 0) {
                throw new NoSuchElementException("No more pages");
            }
            this.request.setLimit(nextLimit);
        }
        this.request.setExclusiveStartKey(this.lastEvaluatedKey);
        QueryResult result = this.client.query(this.request);
        int nextIndex = this.index + this.size();
        return new QueryPage(this.client, this.spec, this.request, nextIndex, new QueryOutcome(result));
    }
}

