/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec;

import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import software.amazon.kinesis.shaded.com.amazonaws.event.ProgressListener;
import software.amazon.kinesis.shaded.com.amazonaws.metrics.RequestMetricCollector;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;

class AbstractSpec<T extends AmazonWebServiceRequest> {
    private final T req;

    AbstractSpec(T req) {
        InternalUtils.applyUserAgent(req);
        this.req = req;
    }

    public T getRequest() {
        return this.req;
    }

    public ProgressListener getProgressListener() {
        return ((AmazonWebServiceRequest)this.getRequest()).getGeneralProgressListener();
    }

    public void setProgressListener(ProgressListener progressListener) {
        ((AmazonWebServiceRequest)this.getRequest()).setGeneralProgressListener(progressListener);
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return ((AmazonWebServiceRequest)this.getRequest()).getRequestMetricCollector();
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        ((AmazonWebServiceRequest)this.getRequest()).setRequestMetricCollector(requestMetricCollector);
    }

    public AbstractSpec<T> withProgressListener(ProgressListener progressListener) {
        ((AmazonWebServiceRequest)this.getRequest()).setGeneralProgressListener(progressListener);
        return this;
    }

    public AbstractSpec<T> withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        ((AmazonWebServiceRequest)this.getRequest()).setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

