/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.event.ProgressListener;
import software.amazon.kinesis.shaded.com.amazonaws.metrics.RequestMetricCollector;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.AbstractSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;

public class BatchGetItemSpec
extends AbstractSpec<BatchGetItemRequest> {
    private Collection<TableKeysAndAttributes> tableKeyAndAttributes;
    private Map<String, KeysAndAttributes> unprocessedKeys;

    public BatchGetItemSpec() {
        super(new BatchGetItemRequest());
    }

    public Collection<TableKeysAndAttributes> getTableKeysAndAttributes() {
        return this.tableKeyAndAttributes;
    }

    public BatchGetItemSpec withTableKeyAndAttributes(TableKeysAndAttributes ... tableKeyAndAttributes) {
        if (tableKeyAndAttributes == null) {
            this.tableKeyAndAttributes = null;
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (TableKeysAndAttributes e : tableKeyAndAttributes) {
                names.add(e.getTableName());
            }
            if (names.size() != tableKeyAndAttributes.length) {
                throw new IllegalArgumentException("table names must not duplicate in the list of TableKeysAndAttributes");
            }
            this.tableKeyAndAttributes = Arrays.asList(tableKeyAndAttributes);
        }
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((BatchGetItemRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public BatchGetItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity capacity) {
        ((BatchGetItemRequest)this.getRequest()).withReturnConsumedCapacity(capacity);
        return this;
    }

    public BatchGetItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public BatchGetItemSpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public BatchGetItemSpec withUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.unprocessedKeys = Collections.unmodifiableMap(new LinkedHashMap<String, KeysAndAttributes>(unprocessedKeys));
        return this;
    }
}

