/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceResult;
import software.amazon.kinesis.shaded.com.amazonaws.ResponseMetadata;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;

public class BatchGetItemResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Map<String, List<Map<String, AttributeValue>>> responses;
    private Map<String, KeysAndAttributes> unprocessedKeys;
    private List<ConsumedCapacity> consumedCapacity;

    public Map<String, List<Map<String, AttributeValue>>> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, List<Map<String, AttributeValue>>> responses) {
        this.responses = responses;
    }

    public BatchGetItemResult withResponses(Map<String, List<Map<String, AttributeValue>>> responses) {
        this.setResponses(responses);
        return this;
    }

    public BatchGetItemResult addResponsesEntry(String key, List<Map<String, AttributeValue>> value) {
        if (null == this.responses) {
            this.responses = new HashMap<String, List<Map<String, AttributeValue>>>();
        }
        if (this.responses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.responses.put(key, value);
        return this;
    }

    public BatchGetItemResult clearResponsesEntries() {
        this.responses = null;
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public void setUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.unprocessedKeys = unprocessedKeys;
    }

    public BatchGetItemResult withUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.setUnprocessedKeys(unprocessedKeys);
        return this;
    }

    public BatchGetItemResult addUnprocessedKeysEntry(String key, KeysAndAttributes value) {
        if (null == this.unprocessedKeys) {
            this.unprocessedKeys = new HashMap<String, KeysAndAttributes>();
        }
        if (this.unprocessedKeys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.unprocessedKeys.put(key, value);
        return this;
    }

    public BatchGetItemResult clearUnprocessedKeysEntries() {
        this.unprocessedKeys = null;
        return this;
    }

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
            return;
        }
        this.consumedCapacity = new ArrayList<ConsumedCapacity>(consumedCapacity);
    }

    public BatchGetItemResult withConsumedCapacity(ConsumedCapacity ... consumedCapacity) {
        if (this.consumedCapacity == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacity.length));
        }
        for (ConsumedCapacity ele : consumedCapacity) {
            this.consumedCapacity.add(ele);
        }
        return this;
    }

    public BatchGetItemResult withConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        this.setConsumedCapacity(consumedCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResponses() != null) {
            sb.append("Responses: ").append(this.getResponses()).append(",");
        }
        if (this.getUnprocessedKeys() != null) {
            sb.append("UnprocessedKeys: ").append(this.getUnprocessedKeys()).append(",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.getConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResult)) {
            return false;
        }
        BatchGetItemResult other = (BatchGetItemResult)obj;
        if (other.getResponses() == null ^ this.getResponses() == null) {
            return false;
        }
        if (other.getResponses() != null && !other.getResponses().equals(this.getResponses())) {
            return false;
        }
        if (other.getUnprocessedKeys() == null ^ this.getUnprocessedKeys() == null) {
            return false;
        }
        if (other.getUnprocessedKeys() != null && !other.getUnprocessedKeys().equals(this.getUnprocessedKeys())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return other.getConsumedCapacity() == null || other.getConsumedCapacity().equals(this.getConsumedCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResponses() == null ? 0 : this.getResponses().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedKeys() == null ? 0 : this.getUnprocessedKeys().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return hashCode;
    }

    public BatchGetItemResult clone() {
        try {
            return (BatchGetItemResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

