/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Shard;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamStatus;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamViewType;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.StreamDescriptionMarshaller;

public class StreamDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String streamArn;
    private String streamLabel;
    private String streamStatus;
    private String streamViewType;
    private Date creationRequestDateTime;
    private String tableName;
    private List<KeySchemaElement> keySchema;
    private List<Shard> shards;
    private String lastEvaluatedShardId;

    public void setStreamArn(String streamArn) {
        this.streamArn = streamArn;
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public StreamDescription withStreamArn(String streamArn) {
        this.setStreamArn(streamArn);
        return this;
    }

    public void setStreamLabel(String streamLabel) {
        this.streamLabel = streamLabel;
    }

    public String getStreamLabel() {
        return this.streamLabel;
    }

    public StreamDescription withStreamLabel(String streamLabel) {
        this.setStreamLabel(streamLabel);
        return this;
    }

    public void setStreamStatus(String streamStatus) {
        this.streamStatus = streamStatus;
    }

    public String getStreamStatus() {
        return this.streamStatus;
    }

    public StreamDescription withStreamStatus(String streamStatus) {
        this.setStreamStatus(streamStatus);
        return this;
    }

    public void setStreamStatus(StreamStatus streamStatus) {
        this.withStreamStatus(streamStatus);
    }

    public StreamDescription withStreamStatus(StreamStatus streamStatus) {
        this.streamStatus = streamStatus.toString();
        return this;
    }

    public void setStreamViewType(String streamViewType) {
        this.streamViewType = streamViewType;
    }

    public String getStreamViewType() {
        return this.streamViewType;
    }

    public StreamDescription withStreamViewType(String streamViewType) {
        this.setStreamViewType(streamViewType);
        return this;
    }

    public void setStreamViewType(StreamViewType streamViewType) {
        this.withStreamViewType(streamViewType);
    }

    public StreamDescription withStreamViewType(StreamViewType streamViewType) {
        this.streamViewType = streamViewType.toString();
        return this;
    }

    public void setCreationRequestDateTime(Date creationRequestDateTime) {
        this.creationRequestDateTime = creationRequestDateTime;
    }

    public Date getCreationRequestDateTime() {
        return this.creationRequestDateTime;
    }

    public StreamDescription withCreationRequestDateTime(Date creationRequestDateTime) {
        this.setCreationRequestDateTime(creationRequestDateTime);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public StreamDescription withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        this.keySchema = new ArrayList<KeySchemaElement>(keySchema);
    }

    public StreamDescription withKeySchema(KeySchemaElement ... keySchema) {
        if (this.keySchema == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement ele : keySchema) {
            this.keySchema.add(ele);
        }
        return this;
    }

    public StreamDescription withKeySchema(Collection<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public List<Shard> getShards() {
        return this.shards;
    }

    public void setShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        this.shards = new ArrayList<Shard>(shards);
    }

    public StreamDescription withShards(Shard ... shards) {
        if (this.shards == null) {
            this.setShards(new ArrayList<Shard>(shards.length));
        }
        for (Shard ele : shards) {
            this.shards.add(ele);
        }
        return this;
    }

    public StreamDescription withShards(Collection<Shard> shards) {
        this.setShards(shards);
        return this;
    }

    public void setLastEvaluatedShardId(String lastEvaluatedShardId) {
        this.lastEvaluatedShardId = lastEvaluatedShardId;
    }

    public String getLastEvaluatedShardId() {
        return this.lastEvaluatedShardId;
    }

    public StreamDescription withLastEvaluatedShardId(String lastEvaluatedShardId) {
        this.setLastEvaluatedShardId(lastEvaluatedShardId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamArn() != null) {
            sb.append("StreamArn: ").append(this.getStreamArn()).append(",");
        }
        if (this.getStreamLabel() != null) {
            sb.append("StreamLabel: ").append(this.getStreamLabel()).append(",");
        }
        if (this.getStreamStatus() != null) {
            sb.append("StreamStatus: ").append(this.getStreamStatus()).append(",");
        }
        if (this.getStreamViewType() != null) {
            sb.append("StreamViewType: ").append(this.getStreamViewType()).append(",");
        }
        if (this.getCreationRequestDateTime() != null) {
            sb.append("CreationRequestDateTime: ").append(this.getCreationRequestDateTime()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: ").append(this.getKeySchema()).append(",");
        }
        if (this.getShards() != null) {
            sb.append("Shards: ").append(this.getShards()).append(",");
        }
        if (this.getLastEvaluatedShardId() != null) {
            sb.append("LastEvaluatedShardId: ").append(this.getLastEvaluatedShardId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        if (other.getStreamArn() == null ^ this.getStreamArn() == null) {
            return false;
        }
        if (other.getStreamArn() != null && !other.getStreamArn().equals(this.getStreamArn())) {
            return false;
        }
        if (other.getStreamLabel() == null ^ this.getStreamLabel() == null) {
            return false;
        }
        if (other.getStreamLabel() != null && !other.getStreamLabel().equals(this.getStreamLabel())) {
            return false;
        }
        if (other.getStreamStatus() == null ^ this.getStreamStatus() == null) {
            return false;
        }
        if (other.getStreamStatus() != null && !other.getStreamStatus().equals(this.getStreamStatus())) {
            return false;
        }
        if (other.getStreamViewType() == null ^ this.getStreamViewType() == null) {
            return false;
        }
        if (other.getStreamViewType() != null && !other.getStreamViewType().equals(this.getStreamViewType())) {
            return false;
        }
        if (other.getCreationRequestDateTime() == null ^ this.getCreationRequestDateTime() == null) {
            return false;
        }
        if (other.getCreationRequestDateTime() != null && !other.getCreationRequestDateTime().equals(this.getCreationRequestDateTime())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        if (other.getShards() != null && !other.getShards().equals(this.getShards())) {
            return false;
        }
        if (other.getLastEvaluatedShardId() == null ^ this.getLastEvaluatedShardId() == null) {
            return false;
        }
        return other.getLastEvaluatedShardId() == null || other.getLastEvaluatedShardId().equals(this.getLastEvaluatedShardId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamArn() == null ? 0 : this.getStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.getStreamLabel() == null ? 0 : this.getStreamLabel().hashCode());
        hashCode = 31 * hashCode + (this.getStreamStatus() == null ? 0 : this.getStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStreamViewType() == null ? 0 : this.getStreamViewType().hashCode());
        hashCode = 31 * hashCode + (this.getCreationRequestDateTime() == null ? 0 : this.getCreationRequestDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : this.getShards().hashCode());
        hashCode = 31 * hashCode + (this.getLastEvaluatedShardId() == null ? 0 : this.getLastEvaluatedShardId().hashCode());
        return hashCode;
    }

    public StreamDescription clone() {
        try {
            return (StreamDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

