/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ParameterizedStatement;

@SdkInternalApi
public class ParameterizedStatementMarshaller {
    private static final MarshallingInfo<String> STATEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statement").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final ParameterizedStatementMarshaller instance = new ParameterizedStatementMarshaller();

    public static ParameterizedStatementMarshaller getInstance() {
        return instance;
    }

    public void marshall(ParameterizedStatement parameterizedStatement, ProtocolMarshaller protocolMarshaller) {
        if (parameterizedStatement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(parameterizedStatement.getStatement(), STATEMENT_BINDING);
            protocolMarshaller.marshall(parameterizedStatement.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

