/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonServiceException;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.ResponseMetadata;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.metrics.RequestMetricCollector;
import software.amazon.kinesis.shaded.com.amazonaws.regions.Region;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetRecordsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Shard;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamDescription;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.StreamRecord;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TrimmedDataAccessException;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.AdapterRequestCache;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.AmazonServiceExceptionTransformer;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.DescribeStreamRequestAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.DescribeStreamResultAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.GetRecordsRequestAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.GetRecordsResultAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.GetShardIteratorRequestAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.GetShardIteratorResultAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.ListStreamsRequestAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.ListStreamsResultAdapter;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.AbstractAmazonKinesis;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.CreateStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.CreateStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DeleteStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ListStreamsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ListStreamsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.MergeShardsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.MergeShardsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.PutRecordRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.PutRecordResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.PutRecordsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.PutRecordsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.RemoveTagsFromStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.SplitShardRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.SplitShardResult;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class AmazonDynamoDBStreamsAdapterClient
extends AbstractAmazonKinesis {
    private static final int REQUEST_CACHE_CAPACITY = 50;
    private static final Log LOG = LogFactory.getLog(AmazonDynamoDBStreamsAdapterClient.class);
    public static final Integer GET_RECORDS_LIMIT = 1000;
    private final AmazonDynamoDBStreams internalClient;
    private final AdapterRequestCache requestCache = new AdapterRequestCache(50);
    private static final String MILLIS_BEHIND_LATEST_METRIC = "MillisBehindLatest";
    private SkipRecordsBehavior skipRecordsBehavior = SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON;
    private boolean generateRecordBytes = true;

    public AmazonDynamoDBStreamsAdapterClient() {
        this.internalClient = new AmazonDynamoDBStreamsClient();
    }

    public AmazonDynamoDBStreamsAdapterClient(ClientConfiguration clientConfiguration) {
        this.internalClient = new AmazonDynamoDBStreamsClient(clientConfiguration);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentials awsCredentials) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentials);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentials, clientConfiguration);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentialsProvider awsCredentialsProvider) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentialsProvider);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentialsProvider, clientConfiguration);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentialsProvider, clientConfiguration, requestMetricCollector);
    }

    public AmazonDynamoDBStreamsAdapterClient(AmazonDynamoDBStreams amazonDynamoDBStreams) {
        this.internalClient = amazonDynamoDBStreams;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.internalClient.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        this.internalClient.setRegion(region);
    }

    public void setGenerateRecordBytes(boolean generateRecordBytes) {
        this.generateRecordBytes = generateRecordBytes;
    }

    @Override
    public software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(DescribeStreamRequest describeStreamRequest) {
        DescribeStreamResult result;
        DescribeStreamRequestAdapter requestAdapter = new DescribeStreamRequestAdapter(describeStreamRequest);
        this.requestCache.addEntry(describeStreamRequest, requestAdapter);
        try {
            result = this.internalClient.describeStream(requestAdapter);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisDescribeStream(e);
        }
        if (result.getStreamDescription().getStreamStatus().equals("DISABLED")) {
            List<Shard> allShards = this.getAllShardsForDisabledStream(result);
            this.markLeafShardsAsActive(allShards);
            StreamDescription newStreamDescription = new StreamDescription().withShards(allShards).withLastEvaluatedShardId(null).withCreationRequestDateTime(result.getStreamDescription().getCreationRequestDateTime()).withKeySchema(result.getStreamDescription().getKeySchema()).withStreamArn(result.getStreamDescription().getStreamArn()).withStreamLabel(result.getStreamDescription().getStreamLabel()).withStreamStatus(result.getStreamDescription().getStreamStatus()).withTableName(result.getStreamDescription().getTableName()).withStreamViewType(result.getStreamDescription().getStreamViewType());
            result = new DescribeStreamResult().withStreamDescription(newStreamDescription);
        }
        return new DescribeStreamResultAdapter(result);
    }

    private List<Shard> getAllShardsForDisabledStream(DescribeStreamResult initialResult) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        shards.addAll(initialResult.getStreamDescription().getShards());
        DescribeStreamResult result = initialResult;
        while (result.getStreamDescription().getLastEvaluatedShardId() != null) {
            software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest request = new software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest().withStreamArn(result.getStreamDescription().getStreamArn()).withExclusiveStartShardId(result.getStreamDescription().getLastEvaluatedShardId());
            try {
                result = this.internalClient.describeStream(request);
            }
            catch (AmazonServiceException e) {
                throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisDescribeStream(e);
            }
            shards.addAll(result.getStreamDescription().getShards());
        }
        return shards;
    }

    private void markLeafShardsAsActive(List<Shard> shards) {
        ArrayList<String> parentShardIds = new ArrayList<String>();
        for (Shard shard : shards) {
            if (shard.getParentShardId() == null) continue;
            parentShardIds.add(shard.getParentShardId());
        }
        for (Shard shard : shards) {
            if (parentShardIds.contains(shard.getShardId())) continue;
            shard.getSequenceNumberRange().setEndingSequenceNumber(null);
        }
    }

    @Override
    public software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(String streamName) {
        return this.describeStream(streamName, null, null);
    }

    @Override
    public software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(String streamName, String exclusiveStartShardId) {
        return this.describeStream(streamName, null, exclusiveStartShardId);
    }

    @Override
    public software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(String streamName, Integer limit, String exclusiveStartShardId) {
        DescribeStreamRequest request = new DescribeStreamRequest();
        request.setStreamName(streamName);
        request.setLimit(limit);
        request.setExclusiveStartShardId(exclusiveStartShardId);
        return this.describeStream(request);
    }

    @Override
    public GetShardIteratorResult getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        GetShardIteratorRequestAdapter requestAdapter = new GetShardIteratorRequestAdapter(getShardIteratorRequest);
        this.requestCache.addEntry(getShardIteratorRequest, requestAdapter);
        try {
            software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult result = this.internalClient.getShardIterator(requestAdapter);
            if (result != null && result.getShardIterator() == null && result.getSdkResponseMetadata() != null) {
                LOG.info("RequestId for getShardIterator call which resulted in ShardEnd: " + ((ResponseMetadata)result.getSdkResponseMetadata()).getRequestId());
            }
            return new GetShardIteratorResultAdapter(result);
        }
        catch (TrimmedDataAccessException e) {
            if (this.skipRecordsBehavior == SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) {
                if (getShardIteratorRequest.getShardIteratorType().equals(ShardIteratorType.TRIM_HORIZON.toString())) {
                    throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator(e, this.skipRecordsBehavior);
                }
                LOG.warn(String.format("Data has been trimmed. Intercepting DynamoDB exception and retrieving a fresh iterator %s", getShardIteratorRequest), e);
                getShardIteratorRequest.setShardIteratorType(ShardIteratorType.TRIM_HORIZON);
                getShardIteratorRequest.setStartingSequenceNumber(null);
                return this.getShardIterator(getShardIteratorRequest);
            }
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator(e, this.skipRecordsBehavior);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator(e, this.skipRecordsBehavior);
        }
    }

    @Override
    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType) {
        return this.getShardIterator(streamName, shardId, shardIteratorType, null);
    }

    @Override
    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        GetShardIteratorRequest request = new GetShardIteratorRequest();
        request.setStreamName(streamName);
        request.setShardId(shardId);
        request.setShardIteratorType(shardIteratorType);
        request.setStartingSequenceNumber(startingSequenceNumber);
        return this.getShardIterator(request);
    }

    @Override
    public PutRecordResult putRecord(PutRecordRequest putRecordRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PutRecordsResult putRecords(PutRecordsRequest putRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsResult getRecords(GetRecordsRequest getRecordsRequest) {
        if (getRecordsRequest.getLimit() != null && getRecordsRequest.getLimit() > GET_RECORDS_LIMIT) {
            getRecordsRequest.setLimit(GET_RECORDS_LIMIT);
        }
        GetRecordsRequestAdapter requestAdapter = new GetRecordsRequestAdapter(getRecordsRequest);
        this.requestCache.addEntry(getRecordsRequest, requestAdapter);
        try {
            GetRecordsResult result = this.internalClient.getRecords(requestAdapter);
            List<Record> records = result.getRecords();
            if (records != null && !records.isEmpty()) {
                int lastIndex = result.getRecords().size() - 1;
                StreamRecord lastStreamRecord = result.getRecords().get(lastIndex).getDynamodb();
                double lastApproximateCreationTimestamp = lastStreamRecord.getApproximateCreationDateTime().getTime();
                double millisBehindLatest = Math.max((double)System.currentTimeMillis() - lastApproximateCreationTimestamp, 0.0);
                IMetricsScope scope = MetricsHelper.getMetricsScope();
                scope.addData(MILLIS_BEHIND_LATEST_METRIC, millisBehindLatest, StandardUnit.Milliseconds, MetricsLevel.SUMMARY);
            }
            if (result != null && result.getNextShardIterator() == null && result.getSdkResponseMetadata() != null) {
                LOG.info("RequestId for getRecords which resulted in ShardEnd: " + ((ResponseMetadata)result.getSdkResponseMetadata()).getRequestId());
            }
            return new GetRecordsResultAdapter(result, this.generateRecordBytes);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetRecords(e, this.skipRecordsBehavior);
        }
    }

    @Override
    public SplitShardResult splitShard(SplitShardRequest splitShardRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SplitShardResult splitShard(String streamName, String shardToSplit, String newStartingHashKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreateStreamResult createStream(CreateStreamRequest createStreamRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreateStreamResult createStream(String streamName, Integer shardCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DeleteStreamResult deleteStream(DeleteStreamRequest deleteStreamRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DeleteStreamResult deleteStream(String streamName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListStreamsResult listStreams(ListStreamsRequest listStreamsRequest) {
        ListStreamsRequestAdapter requestAdapter = new ListStreamsRequestAdapter(listStreamsRequest);
        this.requestCache.addEntry(listStreamsRequest, requestAdapter);
        try {
            software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListStreamsResult result = this.internalClient.listStreams(requestAdapter);
            return new ListStreamsResultAdapter(result);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisListStreams(e);
        }
    }

    @Override
    public ListStreamsResult listStreams() {
        return this.listStreams(null, null);
    }

    @Override
    public ListStreamsResult listStreams(String exclusiveStartStreamName) {
        return this.listStreams(null, exclusiveStartStreamName);
    }

    @Override
    public ListStreamsResult listStreams(Integer limit, String exclusiveStartStreamName) {
        ListStreamsRequest request = new ListStreamsRequest();
        request.setLimit(limit);
        request.setExclusiveStartStreamName(exclusiveStartStreamName);
        return this.listStreams(request);
    }

    @Override
    public MergeShardsResult mergeShards(MergeShardsRequest mergeShardsRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MergeShardsResult mergeShards(String streamName, String shardToMerge, String adjacentShardToMerge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AddTagsToStreamResult addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListTagsForStreamResult listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RemoveTagsFromStreamResult removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        this.internalClient.shutdown();
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.internalClient.getCachedResponseMetadata(this.requestCache.getEntry(request));
    }

    public SkipRecordsBehavior getSkipRecordsBehavior() {
        return this.skipRecordsBehavior;
    }

    public void setSkipRecordsBehavior(SkipRecordsBehavior skipRecordsBehavior) {
        if (skipRecordsBehavior == null) {
            throw new NullPointerException("skipRecordsBehavior cannot be null");
        }
        this.skipRecordsBehavior = skipRecordsBehavior;
    }

    @Override
    public DecreaseStreamRetentionPeriodResult decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IncreaseStreamRetentionPeriodResult increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        throw new UnsupportedOperationException();
    }

    public static enum SkipRecordsBehavior {
        SKIP_RECORDS_TO_TRIM_HORIZON,
        KCL_RETRY;

    }
}

