/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.model.RecordObjectMapper;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class RecordAdapter
extends Record {
    private static Log LOG = LogFactory.getLog(RecordAdapter.class);
    public static final Charset defaultCharset = Charset.forName("UTF-8");
    private static final ObjectMapper MAPPER = new RecordObjectMapper();
    private final software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record internalRecord;
    private ByteBuffer data;
    private boolean generateDataBytes;

    public RecordAdapter(software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record record) {
        this(record, true);
    }

    RecordAdapter(software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record record, boolean generateDataBytes) {
        this.internalRecord = record;
        this.generateDataBytes = generateDataBytes;
    }

    public software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Record getInternalObject() {
        return this.internalRecord;
    }

    @Override
    public String getSequenceNumber() {
        return this.internalRecord.getDynamodb().getSequenceNumber();
    }

    @Override
    public void setSequenceNumber(String sequenceNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record withSequenceNumber(String sequenceNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getData() {
        if (this.data == null) {
            if (this.generateDataBytes) {
                try {
                    this.data = ByteBuffer.wrap(MAPPER.writeValueAsString(this.internalRecord).getBytes(defaultCharset));
                }
                catch (JsonProcessingException e) {
                    String errorMessage = "Failed to serialize stream record to JSON";
                    LOG.error("Failed to serialize stream record to JSON", e);
                    throw new RuntimeException("Failed to serialize stream record to JSON", e);
                }
            } else {
                this.data = ByteBuffer.wrap(new byte[0]);
            }
        }
        return this.data;
    }

    @Override
    public void setData(ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record withData(ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPartitionKey() {
        return null;
    }

    @Override
    public void setPartitionKey(String partitionKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record withPartitionKey(String partitionKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getApproximateArrivalTimestamp() {
        return this.internalRecord.getDynamodb().getApproximateCreationDateTime();
    }

    @Override
    public void setApproximateArrivalTimestamp(Date approximateArrivalTimestamp) {
        this.internalRecord.getDynamodb().setApproximateCreationDateTime(approximateArrivalTimestamp);
    }

    @Override
    public Record withApproximateArrivalTimestamp(Date approximateArrivalTimestamp) {
        this.setApproximateArrivalTimestamp(approximateArrivalTimestamp);
        return this;
    }
}

