/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.waiters;

import java.io.IOException;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonServiceException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import software.amazon.kinesis.shaded.com.amazonaws.jmespath.JmesPathExpression;
import software.amazon.kinesis.shaded.com.amazonaws.jmespath.JmesPathField;
import software.amazon.kinesis.shaded.com.amazonaws.jmespath.JmesPathSubExpression;
import software.amazon.kinesis.shaded.com.amazonaws.jmespath.ObjectMapperSingleton;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.AcceptorPathMatcher;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterAcceptor;
import software.amazon.kinesis.shaded.com.amazonaws.waiters.WaiterState;
import software.amazon.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;

@SdkInternalApi
class TableExists {
    TableExists() {
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeTableResult> {
        IsResourceNotFoundExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeTableResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsACTIVEMatcher() {
        }

        @Override
        public boolean matches(DescribeTableResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("Table"), new JmesPathField("TableStatus"));
        }
    }
}

