/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.PeriodicShardSyncManager;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategyType;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTaskManager;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import software.amazon.kinesis.shaded.org.apache.commons.logging.Log;
import software.amazon.kinesis.shaded.org.apache.commons.logging.LogFactory;

class ShardEndShardSyncStrategy
implements ShardSyncStrategy {
    private static final Log LOG = LogFactory.getLog(Worker.class);
    private ShardSyncTaskManager shardSyncTaskManager;
    private PeriodicShardSyncManager periodicShardSyncManager;

    ShardEndShardSyncStrategy(ShardSyncTaskManager shardSyncTaskManager, PeriodicShardSyncManager periodicShardSyncManager) {
        this.shardSyncTaskManager = shardSyncTaskManager;
        this.periodicShardSyncManager = periodicShardSyncManager;
    }

    @Override
    public ShardSyncStrategyType getStrategyType() {
        return ShardSyncStrategyType.SHARD_END;
    }

    @Override
    public TaskResult syncShards() {
        Future<TaskResult> taskResultFuture = null;
        TaskResult result = null;
        while (taskResultFuture == null) {
            taskResultFuture = this.shardSyncTaskManager.syncShardAndLeaseInfo(null);
        }
        try {
            result = (TaskResult)taskResultFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("ShardEndShardSyncStrategy syncShards encountered exception.", e);
        }
        return result;
    }

    @Override
    public TaskResult onWorkerInitialization() {
        LOG.info("Starting periodic shard sync background process for SHARD_END shard sync strategy.");
        return this.periodicShardSyncManager.start();
    }

    @Override
    public TaskResult onFoundCompletedShard() {
        this.shardSyncTaskManager.syncShardAndLeaseInfo(null);
        return new TaskResult(null);
    }

    @Override
    public TaskResult onShardConsumerShutDown() {
        return this.onFoundCompletedShard();
    }

    @Override
    public TaskResult onShardConsumerShutDown(List<Shard> latestShards) {
        this.shardSyncTaskManager.syncShardAndLeaseInfo(latestShards);
        return new TaskResult(null);
    }

    @Override
    public void onWorkerShutDown() {
        LOG.info("Stopping periodic shard sync background process for SHARD_END shard sync strategy.");
        this.periodicShardSyncManager.stop();
    }
}

