/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.HashKeyRange;

@SdkInternalApi
public class HashKeyRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGHASHKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingHashKey").build();
    private static final MarshallingInfo<String> ENDINGHASHKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingHashKey").build();
    private static final HashKeyRangeMarshaller instance = new HashKeyRangeMarshaller();

    public static HashKeyRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(HashKeyRange hashKeyRange, ProtocolMarshaller protocolMarshaller) {
        if (hashKeyRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hashKeyRange.getStartingHashKey(), STARTINGHASHKEY_BINDING);
            protocolMarshaller.marshall(hashKeyRange.getEndingHashKey(), ENDINGHASHKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

