/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.multilang.messages;

import java.util.ArrayList;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.multilang.messages.JsonFriendlyRecord;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.multilang.messages.Message;

public class ProcessRecordsMessage
extends Message {
    public static final String ACTION = "processRecords";
    private List<JsonFriendlyRecord> records;
    private Long millisBehindLatest;

    public ProcessRecordsMessage() {
    }

    public ProcessRecordsMessage(ProcessRecordsInput processRecordsInput) {
        this.millisBehindLatest = processRecordsInput.getMillisBehindLatest();
        ArrayList<JsonFriendlyRecord> recordMessages = new ArrayList<JsonFriendlyRecord>();
        for (Record record : processRecordsInput.getRecords()) {
            recordMessages.add(new JsonFriendlyRecord(record));
        }
        this.setRecords(recordMessages);
    }

    public List<JsonFriendlyRecord> getRecords() {
        return this.records;
    }

    public Long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }

    public void setRecords(List<JsonFriendlyRecord> records) {
        this.records = records;
    }

    public void setMillisBehindLatest(Long millisBehindLatest) {
        this.millisBehindLatest = millisBehindLatest;
    }
}

