/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.producer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.shaded.org.apache.commons.io.IOUtils;

public class HashedFileCopier {
    private static final Logger log = LoggerFactory.getLogger(HashedFileCopier.class);
    static final String MESSAGE_DIGEST_ALGORITHM = "SHA-1";
    static final String TEMP_PREFIX = "kpl";
    static final String TEMP_SUFFIX = ".tmp";
    static final String LOCK_SUFFIX = ".lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFileFrom(InputStream sourceData, File destinationDirectory, String fileNameFormat) throws Exception {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(TEMP_PREFIX, TEMP_SUFFIX, destinationDirectory);
            log.debug("Extracting file with format {}", (Object)fileNameFormat);
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            DigestOutputStream digestOutputStream = new DigestOutputStream(fileOutputStream, MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM));
            IOUtils.copy(sourceData, (OutputStream)digestOutputStream);
            digestOutputStream.close();
            byte[] digest = digestOutputStream.getMessageDigest().digest();
            log.debug("Calculated digest of new file: {}", (Object)Arrays.toString(digest));
            String digestHex = DatatypeConverter.printHexBinary((byte[])digest);
            File finalFile = new File(destinationDirectory, String.format(fileNameFormat, digestHex));
            File lockFile = new File(destinationDirectory, String.format(fileNameFormat + LOCK_SUFFIX, digestHex));
            log.debug("Preparing to check and copy {} to {}", (Object)tempFile.getAbsolutePath(), (Object)finalFile.getAbsolutePath());
            try (FileOutputStream lockFOS = new FileOutputStream(lockFile);
                 FileLock lock = lockFOS.getChannel().lock();){
                if (finalFile.exists() && finalFile.length() == tempFile.length()) {
                    byte[] existingFileDigest = null;
                    try (DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(finalFile), MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM));){
                        byte[] discardedBytes = new byte[8192];
                        while (digestInputStream.read(discardedBytes) != -1) {
                        }
                        existingFileDigest = digestInputStream.getMessageDigest().digest();
                    }
                    if (Arrays.equals(digest, existingFileDigest)) {
                        log.info("'{}' already exists, and matches.  Not overwriting.", (Object)finalFile.getAbsolutePath());
                        File file = finalFile;
                        return file;
                    }
                    log.warn("Detected a mismatch between the existing file, and the new file.  Will overwrite the existing file. Existing: {} -- New File: {}", (Object)Arrays.toString(existingFileDigest), (Object)Arrays.toString(digest));
                }
                if (!tempFile.renameTo(finalFile)) {
                    log.error("Failed to rename '{}' to '{}'", (Object)tempFile.getAbsolutePath(), (Object)finalFile.getAbsolutePath());
                    throw new IOException("Failed to rename extracted file");
                }
            }
            File file = finalFile;
            return file;
        }
        finally {
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                log.warn("Unable to delete temp file: {}", (Object)tempFile.getAbsolutePath());
            }
        }
    }
}

