/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.InputConfiguration;

public class StartApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private List<InputConfiguration> inputConfigurations;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public StartApplicationRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public List<InputConfiguration> getInputConfigurations() {
        return this.inputConfigurations;
    }

    public void setInputConfigurations(Collection<InputConfiguration> inputConfigurations) {
        if (inputConfigurations == null) {
            this.inputConfigurations = null;
            return;
        }
        this.inputConfigurations = new ArrayList<InputConfiguration>(inputConfigurations);
    }

    public StartApplicationRequest withInputConfigurations(InputConfiguration ... inputConfigurations) {
        if (this.inputConfigurations == null) {
            this.setInputConfigurations(new ArrayList<InputConfiguration>(inputConfigurations.length));
        }
        for (InputConfiguration ele : inputConfigurations) {
            this.inputConfigurations.add(ele);
        }
        return this;
    }

    public StartApplicationRequest withInputConfigurations(Collection<InputConfiguration> inputConfigurations) {
        this.setInputConfigurations(inputConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getInputConfigurations() != null) {
            sb.append("InputConfigurations: ").append(this.getInputConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getInputConfigurations() == null ^ this.getInputConfigurations() == null) {
            return false;
        }
        return other.getInputConfigurations() == null || other.getInputConfigurations().equals(this.getInputConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getInputConfigurations() == null ? 0 : this.getInputConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public StartApplicationRequest clone() {
        return (StartApplicationRequest)super.clone();
    }
}

