/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.CloudWatchLoggingOption;

@SdkInternalApi
public class CloudWatchLoggingOptionMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreamARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final CloudWatchLoggingOptionMarshaller instance = new CloudWatchLoggingOptionMarshaller();

    public static CloudWatchLoggingOptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchLoggingOption cloudWatchLoggingOption, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLoggingOption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cloudWatchLoggingOption.getLogStreamARN(), LOGSTREAMARN_BINDING);
            protocolMarshaller.marshall(cloudWatchLoggingOption.getRoleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

