/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.Output;

@SdkInternalApi
public class OutputMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamsOutput").build();
    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisFirehoseOutput").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAOUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaOutput").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSchema").build();
    private static final OutputMarshaller instance = new OutputMarshaller();

    public static OutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Output output, ProtocolMarshaller protocolMarshaller) {
        if (output == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(output.getName(), NAME_BINDING);
            protocolMarshaller.marshall(output.getKinesisStreamsOutput(), KINESISSTREAMSOUTPUT_BINDING);
            protocolMarshaller.marshall(output.getKinesisFirehoseOutput(), KINESISFIREHOSEOUTPUT_BINDING);
            protocolMarshaller.marshall(output.getLambdaOutput(), LAMBDAOUTPUT_BINDING);
            protocolMarshaller.marshall(output.getDestinationSchema(), DESTINATIONSCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

