/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.S3ReferenceDataSourceDescription;

@SdkInternalApi
public class S3ReferenceDataSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").build();
    private static final MarshallingInfo<String> FILEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKey").build();
    private static final MarshallingInfo<String> REFERENCEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARN").build();
    private static final S3ReferenceDataSourceDescriptionMarshaller instance = new S3ReferenceDataSourceDescriptionMarshaller();

    public static S3ReferenceDataSourceDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription, ProtocolMarshaller protocolMarshaller) {
        if (s3ReferenceDataSourceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ReferenceDataSourceDescription.getBucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall(s3ReferenceDataSourceDescription.getFileKey(), FILEKEY_BINDING);
            protocolMarshaller.marshall(s3ReferenceDataSourceDescription.getReferenceRoleARN(), REFERENCEROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

