/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.S3ReferenceDataSource;

@SdkInternalApi
public class S3ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").build();
    private static final MarshallingInfo<String> FILEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKey").build();
    private static final MarshallingInfo<String> REFERENCEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARN").build();
    private static final S3ReferenceDataSourceMarshaller instance = new S3ReferenceDataSourceMarshaller();

    public static S3ReferenceDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ReferenceDataSource s3ReferenceDataSource, ProtocolMarshaller protocolMarshaller) {
        if (s3ReferenceDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ReferenceDataSource.getBucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall(s3ReferenceDataSource.getFileKey(), FILEKEY_BINDING);
            protocolMarshaller.marshall(s3ReferenceDataSource.getReferenceRoleARN(), REFERENCEROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

