/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.SourceSchema;

@SdkInternalApi
public class SourceSchemaMarshaller {
    private static final MarshallingInfo<StructuredPojo> RECORDFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormat").build();
    private static final MarshallingInfo<String> RECORDENCODING_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordEncoding").build();
    private static final MarshallingInfo<List> RECORDCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumns").build();
    private static final SourceSchemaMarshaller instance = new SourceSchemaMarshaller();

    public static SourceSchemaMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceSchema sourceSchema, ProtocolMarshaller protocolMarshaller) {
        if (sourceSchema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sourceSchema.getRecordFormat(), RECORDFORMAT_BINDING);
            protocolMarshaller.marshall(sourceSchema.getRecordEncoding(), RECORDENCODING_BINDING);
            protocolMarshaller.marshall(sourceSchema.getRecordColumns(), RECORDCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

