/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import java.util.Date;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.KinesisStreamSourceDescription;

@SdkInternalApi
public class KinesisStreamSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> KINESISSTREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<Date> DELIVERYSTARTTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStartTimestamp").timestampFormat("unixTimestamp").build();
    private static final KinesisStreamSourceDescriptionMarshaller instance = new KinesisStreamSourceDescriptionMarshaller();

    public static KinesisStreamSourceDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(KinesisStreamSourceDescription kinesisStreamSourceDescription, ProtocolMarshaller protocolMarshaller) {
        if (kinesisStreamSourceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(kinesisStreamSourceDescription.getKinesisStreamARN(), KINESISSTREAMARN_BINDING);
            protocolMarshaller.marshall(kinesisStreamSourceDescription.getRoleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(kinesisStreamSourceDescription.getDeliveryStartTimestamp(), DELIVERYSTARTTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

