/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.ParquetSerDe;

@SdkInternalApi
public class ParquetSerDeMarshaller {
    private static final MarshallingInfo<Integer> BLOCKSIZEBYTES_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockSizeBytes").build();
    private static final MarshallingInfo<Integer> PAGESIZEBYTES_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSizeBytes").build();
    private static final MarshallingInfo<String> COMPRESSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compression").build();
    private static final MarshallingInfo<Boolean> ENABLEDICTIONARYCOMPRESSION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableDictionaryCompression").build();
    private static final MarshallingInfo<Integer> MAXPADDINGBYTES_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxPaddingBytes").build();
    private static final MarshallingInfo<String> WRITERVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriterVersion").build();
    private static final ParquetSerDeMarshaller instance = new ParquetSerDeMarshaller();

    public static ParquetSerDeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ParquetSerDe parquetSerDe, ProtocolMarshaller protocolMarshaller) {
        if (parquetSerDe == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(parquetSerDe.getBlockSizeBytes(), BLOCKSIZEBYTES_BINDING);
            protocolMarshaller.marshall(parquetSerDe.getPageSizeBytes(), PAGESIZEBYTES_BINDING);
            protocolMarshaller.marshall(parquetSerDe.getCompression(), COMPRESSION_BINDING);
            protocolMarshaller.marshall(parquetSerDe.getEnableDictionaryCompression(), ENABLEDICTIONARYCOMPRESSION_BINDING);
            protocolMarshaller.marshall(parquetSerDe.getMaxPaddingBytes(), MAXPADDINGBYTES_BINDING);
            protocolMarshaller.marshall(parquetSerDe.getWriterVersion(), WRITERVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

