/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.SourceDescription;

@SdkInternalApi
public class SourceDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOURCEDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamSourceDescription").build();
    private static final SourceDescriptionMarshaller instance = new SourceDescriptionMarshaller();

    public static SourceDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceDescription sourceDescription, ProtocolMarshaller protocolMarshaller) {
        if (sourceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sourceDescription.getKinesisStreamSourceDescription(), KINESISSTREAMSOURCEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

