/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap;

import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.CryptoUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.AesGcmKeyWrapper;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.CipherProvider;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperContext;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperProvider;

public final class AesGcmKeyWrapperProvider
implements KeyWrapperProvider {
    private static final AesGcmKeyWrapperProvider DEFAULT = new AesGcmKeyWrapperProvider();

    private AesGcmKeyWrapperProvider() {
    }

    public static AesGcmKeyWrapperProvider create() {
        return DEFAULT;
    }

    @Override
    public InternalKeyWrapAlgorithm algorithm() {
        return InternalKeyWrapAlgorithm.AES_GCM_NoPadding;
    }

    @Override
    public KeyWrapper createKeyWrapper(KeyWrapperContext keyWrapperContext) {
        String remappedCekAlgorithm = CryptoUtils.normalizeContentAlgorithmForValidation(keyWrapperContext.contentCryptoScheme().getCipherAlgorithm());
        return AesGcmKeyWrapper.builder().cipherProvider(CipherProvider.create(AesGcmKeyWrapper.cipherAlgorithm(), keyWrapperContext.cryptoProvider())).secureRandom(keyWrapperContext.secureRandom()).cekAlgorithm(remappedCekAlgorithm).build();
    }
}

