/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.transform;

import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.EventBridgeConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.NotificationConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.transform.EventBridgeConfigurationStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.transform.LambdaConfigurationStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.transform.QueueConfigurationStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.transform.TopicConfigurationStaxUnmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Unmarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.XmlUtils;

public class BucketNotificationConfigurationStaxUnmarshaller
implements Unmarshaller<BucketNotificationConfiguration, InputStream> {
    private static final BucketNotificationConfigurationStaxUnmarshaller instance = new BucketNotificationConfigurationStaxUnmarshaller();

    public static BucketNotificationConfigurationStaxUnmarshaller getInstance() {
        return instance;
    }

    private BucketNotificationConfigurationStaxUnmarshaller() {
    }

    @Override
    public BucketNotificationConfiguration unmarshall(InputStream inputStream) throws Exception {
        StaxUnmarshallerContext context = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream));
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        BucketNotificationConfiguration config = new BucketNotificationConfiguration();
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return config;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                Map.Entry<String, NotificationConfiguration> entry;
                if (context.testExpression("TopicConfiguration", targetDepth)) {
                    entry = TopicConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("QueueConfiguration", targetDepth)) {
                    entry = QueueConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("CloudFunctionConfiguration", targetDepth)) {
                    entry = LambdaConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!context.testExpression("EventBridgeConfiguration", targetDepth)) continue;
                EventBridgeConfiguration eventBridgeConfig = EventBridgeConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                config.setEventBridgeConfiguration(eventBridgeConfig);
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return config;
    }
}

