/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform;

import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.model.Tag;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class GetFederationTokenRequestMarshaller
implements Marshaller<Request<GetFederationTokenRequest>, GetFederationTokenRequest> {
    @Override
    public Request<GetFederationTokenRequest> marshall(GetFederationTokenRequest getFederationTokenRequest) {
        if (getFederationTokenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetFederationTokenRequest> request = new DefaultRequest<GetFederationTokenRequest>(getFederationTokenRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "GetFederationToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getFederationTokenRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(getFederationTokenRequest.getName()));
        }
        if (getFederationTokenRequest.getPolicy() != null) {
            request.addParameter("Policy", StringUtils.fromString(getFederationTokenRequest.getPolicy()));
        }
        if (getFederationTokenRequest.getPolicyArns() != null) {
            List<PolicyDescriptorType> policyArnsList = getFederationTokenRequest.getPolicyArns();
            if (policyArnsList.isEmpty()) {
                request.addParameter("PolicyArns", "");
            } else {
                int policyArnsListIndex = 1;
                for (PolicyDescriptorType policyArnsListValue : policyArnsList) {
                    if (policyArnsListValue != null && policyArnsListValue.getArn() != null) {
                        request.addParameter("PolicyArns.member." + policyArnsListIndex + ".arn", StringUtils.fromString(policyArnsListValue.getArn()));
                    }
                    ++policyArnsListIndex;
                }
            }
        }
        if (getFederationTokenRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger(getFederationTokenRequest.getDurationSeconds()));
        }
        if (getFederationTokenRequest.getTags() != null) {
            List<Tag> tagsList = getFederationTokenRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

