/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.io.netty.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import software.amazon.kinesis.shaded.io.netty.buffer.ByteBuf;
import software.amazon.kinesis.shaded.io.netty.buffer.ByteBufUtil;
import software.amazon.kinesis.shaded.io.netty.channel.ChannelHandler;
import software.amazon.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import software.amazon.kinesis.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import software.amazon.kinesis.shaded.io.netty.handler.codec.string.LineSeparator;
import software.amazon.kinesis.shaded.io.netty.util.CharsetUtil;
import software.amazon.kinesis.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class LineEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;
    private final byte[] lineSeparator;

    public LineEncoder() {
        this(LineSeparator.DEFAULT, CharsetUtil.UTF_8);
    }

    public LineEncoder(LineSeparator lineSeparator) {
        this(lineSeparator, CharsetUtil.UTF_8);
    }

    public LineEncoder(Charset charset) {
        this(LineSeparator.DEFAULT, charset);
    }

    public LineEncoder(LineSeparator lineSeparator, Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.lineSeparator = ObjectUtil.checkNotNull(lineSeparator, "lineSeparator").value().getBytes(charset);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        ByteBuf buffer = ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset, this.lineSeparator.length);
        buffer.writeBytes(this.lineSeparator);
        out.add(buffer);
    }
}

