/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.org.apache.http.impl.conn;

import software.amazon.kinesis.shaded.org.apache.http.HttpResponse;
import software.amazon.kinesis.shaded.org.apache.http.HttpResponseFactory;
import software.amazon.kinesis.shaded.org.apache.http.annotation.Contract;
import software.amazon.kinesis.shaded.org.apache.http.annotation.ThreadingBehavior;
import software.amazon.kinesis.shaded.org.apache.http.config.MessageConstraints;
import software.amazon.kinesis.shaded.org.apache.http.impl.DefaultHttpResponseFactory;
import software.amazon.kinesis.shaded.org.apache.http.impl.conn.DefaultHttpResponseParser;
import software.amazon.kinesis.shaded.org.apache.http.io.HttpMessageParser;
import software.amazon.kinesis.shaded.org.apache.http.io.HttpMessageParserFactory;
import software.amazon.kinesis.shaded.org.apache.http.io.SessionInputBuffer;
import software.amazon.kinesis.shaded.org.apache.http.message.BasicLineParser;
import software.amazon.kinesis.shaded.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

