/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.internal;

import java.time.Duration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.util.SignerMethodResolver;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.HttpChecksumConstant;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.InternalCoreExecutionAttribute;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.util.HttpChecksumResolver;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class AwsExecutionContextBuilder {
    private AwsExecutionContextBuilder() {
    }

    public static <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext invokeInterceptorsAndCreateExecutionContext(ClientExecutionParams<InputT, OutputT> executionParams, SdkClientConfiguration clientConfig) {
        InputT originalRequest = executionParams.getInput();
        MetricCollector metricCollector = AwsExecutionContextBuilder.resolveMetricCollector(executionParams);
        ExecutionAttributes executionAttributes = AwsExecutionContextBuilder.mergeExecutionAttributeOverrides(executionParams.executionAttributes(), clientConfig.option(SdkClientOption.EXECUTION_ATTRIBUTES), ((SdkRequest)originalRequest).overrideConfiguration().map(c -> c.executionAttributes()).orElse(null));
        executionAttributes.putAttribute(InternalCoreExecutionAttribute.EXECUTION_ATTEMPT, 1).putAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG, clientConfig.option(SdkClientOption.SERVICE_CONFIGURATION)).putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, clientConfig.option(AwsClientOption.SERVICE_SIGNING_NAME)).putAttribute(AwsExecutionAttribute.AWS_REGION, clientConfig.option(AwsClientOption.AWS_REGION)).putAttribute(AwsExecutionAttribute.ENDPOINT_PREFIX, clientConfig.option(AwsClientOption.ENDPOINT_PREFIX)).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, clientConfig.option(AwsClientOption.SIGNING_REGION)).putAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX, executionParams.isFullDuplex()).putAttribute(SdkInternalExecutionAttribute.HAS_INITIAL_REQUEST_EVENT, executionParams.hasInitialRequestEvent()).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, clientConfig.option(SdkClientOption.CLIENT_TYPE)).putAttribute(SdkExecutionAttribute.SERVICE_NAME, clientConfig.option(SdkClientOption.SERVICE_NAME)).putAttribute(SdkExecutionAttribute.PROFILE_FILE, clientConfig.option(SdkClientOption.PROFILE_FILE)).putAttribute(SdkExecutionAttribute.PROFILE_NAME, clientConfig.option(SdkClientOption.PROFILE_NAME)).putAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED, clientConfig.option(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED)).putAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED, clientConfig.option(AwsClientOption.FIPS_ENDPOINT_ENABLED)).putAttribute(SdkExecutionAttribute.OPERATION_NAME, executionParams.getOperationName()).putAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT, clientConfig.option(SdkClientOption.ENDPOINT)).putAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN, clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN)).putAttribute(SdkInternalExecutionAttribute.DISABLE_HOST_PREFIX_INJECTION, clientConfig.option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION)).putAttribute(SdkExecutionAttribute.SIGNER_OVERRIDDEN, clientConfig.option(SdkClientOption.SIGNER_OVERRIDDEN)).putAttribute(SdkExecutionAttribute.RESOLVED_CHECKSUM_SPECS, HttpChecksumResolver.getResolvedChecksumSpecs(executionAttributes));
        ExecutionInterceptorChain executionInterceptorChain = new ExecutionInterceptorChain(clientConfig.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        InterceptorContext interceptorContext = InterceptorContext.builder().request((SdkRequest)originalRequest).asyncRequestBody(executionParams.getAsyncRequestBody()).requestBody(executionParams.getRequestBody()).build();
        interceptorContext = AwsExecutionContextBuilder.runInitialInterceptors(interceptorContext, executionAttributes, executionInterceptorChain);
        Signer signer = AwsExecutionContextBuilder.isAuthenticatedRequest(executionAttributes) ? AwsExecutionContextBuilder.resolveSigner(interceptorContext.request(), clientConfig.option(SdkAdvancedClientOption.SIGNER)) : null;
        AwsCredentials credentials = AwsExecutionContextBuilder.isAuthenticatedRequest(executionAttributes) ? AwsExecutionContextBuilder.resolveCredentials(clientConfig.option(AwsClientOption.CREDENTIALS_PROVIDER), originalRequest, metricCollector) : AnonymousCredentialsProvider.create().resolveCredentials();
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, credentials);
        executionAttributes.putAttribute(HttpChecksumConstant.SIGNING_METHOD, SignerMethodResolver.resolveSigningMethodUsed(signer, executionAttributes, credentials));
        return ExecutionContext.builder().interceptorChain(executionInterceptorChain).interceptorContext(interceptorContext).executionAttributes(executionAttributes).signer(signer).metricCollector(metricCollector).build();
    }

    public static AwsCredentialsProvider resolveCredentialsProvider(SdkRequest originalRequest, AwsCredentialsProvider defaultProvider) {
        return originalRequest.overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)c).flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElse(defaultProvider);
    }

    public static Signer resolveSigner(SdkRequest request, Signer defaultSigner) {
        return request.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(defaultSigner);
    }

    public static InterceptorContext runInitialInterceptors(InterceptorContext interceptorContext, ExecutionAttributes executionAttributes, ExecutionInterceptorChain executionInterceptorChain) {
        executionInterceptorChain.beforeExecution(interceptorContext, executionAttributes);
        return executionInterceptorChain.modifyRequest(interceptorContext, executionAttributes);
    }

    private static AwsCredentials resolveCredentials(AwsCredentialsProvider clientCredentials, SdkRequest originalRequest, MetricCollector metricCollector) {
        AwsCredentialsProvider credentialsProvider = AwsExecutionContextBuilder.resolveCredentialsProvider(originalRequest, clientCredentials);
        long credentialsResolveStart = System.nanoTime();
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Duration fetchDuration = Duration.ofNanos(System.nanoTime() - credentialsResolveStart);
        metricCollector.reportMetric(CoreMetric.CREDENTIALS_FETCH_DURATION, fetchDuration);
        Validate.validState(credentials != null, "Credential providers must never return null.", new Object[0]);
        return credentials;
    }

    private static <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionAttributes mergeExecutionAttributeOverrides(ExecutionAttributes executionAttributes, ExecutionAttributes clientOverrideExecutionAttributes, ExecutionAttributes requestOverrideExecutionAttributes) {
        executionAttributes.putAbsentAttributes(requestOverrideExecutionAttributes);
        executionAttributes.putAbsentAttributes(clientOverrideExecutionAttributes);
        return executionAttributes;
    }

    private static MetricCollector resolveMetricCollector(ClientExecutionParams<?, ?> params) {
        MetricCollector metricCollector = params.getMetricCollector();
        if (metricCollector == null) {
            metricCollector = MetricCollector.create("ApiCall");
        }
        return metricCollector;
    }

    private static boolean isAuthenticatedRequest(ExecutionAttributes executionAttributes) {
        return executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST).orElse(true);
    }
}

