/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.ClientType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.SdkInternalTestAdvancedClientOption;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.loader.DefaultSdkAsyncHttpClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.loader.DefaultSdkHttpClientBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages.ApplyUserAgentStage;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.interceptor.AsyncRequestBodyHttpChecksumTrailerInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.interceptor.HttpChecksumInHeaderInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.interceptor.HttpChecksumRequiredInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.interceptor.HttpChecksumValidationInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.interceptor.SyncHttpChecksumInTrailerInterceptor;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.SdkUserAgent;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Either;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public abstract class SdkDefaultClientBuilder<B extends SdkClientBuilder<B, C>, C>
implements SdkClientBuilder<B, C> {
    private static final SdkHttpClient.Builder DEFAULT_HTTP_CLIENT_BUILDER = new DefaultSdkHttpClientBuilder();
    private static final SdkAsyncHttpClient.Builder DEFAULT_ASYNC_HTTP_CLIENT_BUILDER = new DefaultSdkAsyncHttpClientBuilder();
    protected final SdkClientConfiguration.Builder clientConfiguration = SdkClientConfiguration.builder();
    private final SdkHttpClient.Builder defaultHttpClientBuilder;
    private final SdkAsyncHttpClient.Builder defaultAsyncHttpClientBuilder;
    private ClientOverrideConfiguration clientOverrideConfiguration;
    private SdkHttpClient.Builder httpClientBuilder;
    private SdkAsyncHttpClient.Builder asyncHttpClientBuilder;

    protected SdkDefaultClientBuilder() {
        this(DEFAULT_HTTP_CLIENT_BUILDER, DEFAULT_ASYNC_HTTP_CLIENT_BUILDER);
    }

    @SdkTestInternalApi
    protected SdkDefaultClientBuilder(SdkHttpClient.Builder defaultHttpClientBuilder, SdkAsyncHttpClient.Builder defaultAsyncHttpClientBuilder) {
        this.defaultHttpClientBuilder = defaultHttpClientBuilder;
        this.defaultAsyncHttpClientBuilder = defaultAsyncHttpClientBuilder;
    }

    @Override
    public final C build() {
        return this.buildClient();
    }

    protected abstract C buildClient();

    protected final SdkClientConfiguration syncClientConfiguration() {
        SdkClientConfiguration configuration = this.clientConfiguration.build();
        configuration = this.setOverrides(configuration);
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeSyncConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        return configuration;
    }

    protected final SdkClientConfiguration asyncClientConfiguration() {
        SdkClientConfiguration configuration = this.clientConfiguration.build();
        configuration = this.setOverrides(configuration);
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeAsyncConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        return configuration;
    }

    private SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        if (this.clientOverrideConfiguration == null) {
            return configuration;
        }
        SdkClientConfiguration.Builder builder = configuration.toBuilder();
        builder.option(SdkClientOption.EXECUTION_INTERCEPTORS, this.clientOverrideConfiguration.executionInterceptors());
        builder.option(SdkClientOption.RETRY_POLICY, this.clientOverrideConfiguration.retryPolicy().orElse(null));
        builder.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS, this.clientOverrideConfiguration.headers());
        builder.option(SdkAdvancedClientOption.SIGNER, this.clientOverrideConfiguration.advancedOption(SdkAdvancedClientOption.SIGNER).orElse(null));
        builder.option(SdkAdvancedClientOption.USER_AGENT_SUFFIX, this.clientOverrideConfiguration.advancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX).orElse(null));
        builder.option(SdkAdvancedClientOption.USER_AGENT_PREFIX, this.clientOverrideConfiguration.advancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX).orElse(null));
        builder.option(SdkClientOption.API_CALL_TIMEOUT, this.clientOverrideConfiguration.apiCallTimeout().orElse(null));
        builder.option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT, this.clientOverrideConfiguration.apiCallAttemptTimeout().orElse(null));
        builder.option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION, this.clientOverrideConfiguration.advancedOption(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION).orElse(null));
        builder.option(SdkClientOption.PROFILE_FILE, this.clientOverrideConfiguration.defaultProfileFile().orElse(null));
        builder.option(SdkClientOption.PROFILE_NAME, this.clientOverrideConfiguration.defaultProfileName().orElse(null));
        builder.option(SdkClientOption.METRIC_PUBLISHERS, this.clientOverrideConfiguration.metricPublishers());
        builder.option(SdkClientOption.EXECUTION_ATTRIBUTES, this.clientOverrideConfiguration.executionAttributes());
        this.clientOverrideConfiguration.advancedOption(SdkInternalTestAdvancedClientOption.ENDPOINT_OVERRIDDEN_OVERRIDE).ifPresent(value -> builder.option(SdkClientOption.ENDPOINT_OVERRIDDEN, value));
        this.clientOverrideConfiguration.advancedOption(SdkAdvancedClientOption.SIGNER).ifPresent(s -> builder.option(SdkClientOption.SIGNER_OVERRIDDEN, true));
        return builder.build();
    }

    protected SdkClientConfiguration mergeChildDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    private SdkClientConfiguration mergeGlobalDefaults(SdkClientConfiguration configuration) {
        ProfileFile configuredProfileFile = configuration.option(SdkClientOption.PROFILE_FILE);
        ProfileFile profileFile = configuredProfileFile != null ? configuredProfileFile : ProfileFile.defaultProfileFile();
        return configuration.merge(c -> c.option(SdkClientOption.EXECUTION_INTERCEPTORS, new ArrayList()).option(SdkClientOption.ADDITIONAL_HTTP_HEADERS, new LinkedHashMap()).option(SdkClientOption.PROFILE_FILE, profileFile).option(SdkClientOption.PROFILE_NAME, ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow()).option(SdkAdvancedClientOption.USER_AGENT_PREFIX, SdkUserAgent.create().userAgent()).option(SdkAdvancedClientOption.USER_AGENT_SUFFIX, "").option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false));
    }

    protected SdkClientConfiguration finalizeChildConfiguration(SdkClientConfiguration configuration) {
        return configuration;
    }

    private SdkClientConfiguration finalizeSyncConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().option(SdkClientOption.SYNC_HTTP_CLIENT, this.resolveSyncHttpClient(config)).option(SdkClientOption.CLIENT_TYPE, ClientType.SYNC).build();
    }

    private SdkClientConfiguration finalizeAsyncConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this.resolveAsyncFutureCompletionExecutor(config)).option(SdkClientOption.ASYNC_HTTP_CLIENT, this.resolveAsyncHttpClient(config)).option(SdkClientOption.CLIENT_TYPE, ClientType.ASYNC).build();
    }

    private SdkClientConfiguration finalizeConfiguration(SdkClientConfiguration config) {
        RetryPolicy retryPolicy = this.resolveRetryPolicy(config);
        return config.toBuilder().option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE, this.resolveScheduledExecutorService()).option(SdkClientOption.EXECUTION_INTERCEPTORS, this.resolveExecutionInterceptors(config)).option(SdkClientOption.RETRY_POLICY, retryPolicy).option(SdkClientOption.CLIENT_USER_AGENT, this.resolveClientUserAgent(config, retryPolicy)).build();
    }

    private String resolveClientUserAgent(SdkClientConfiguration config, RetryPolicy retryPolicy) {
        return ApplyUserAgentStage.resolveClientUserAgent(config.option(SdkAdvancedClientOption.USER_AGENT_PREFIX), config.option(SdkClientOption.INTERNAL_USER_AGENT), config.option(SdkClientOption.CLIENT_TYPE), config.option(SdkClientOption.SYNC_HTTP_CLIENT), config.option(SdkClientOption.ASYNC_HTTP_CLIENT), retryPolicy);
    }

    private RetryPolicy resolveRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy policy = config.option(SdkClientOption.RETRY_POLICY);
        if (policy != null) {
            return policy;
        }
        RetryMode retryMode = RetryMode.resolver().profileFile(() -> config.option(SdkClientOption.PROFILE_FILE)).profileName(config.option(SdkClientOption.PROFILE_NAME)).defaultRetryMode(config.option(SdkClientOption.DEFAULT_RETRY_MODE)).resolve();
        return RetryPolicy.forRetryMode(retryMode);
    }

    private SdkHttpClient resolveSyncHttpClient(SdkClientConfiguration config) {
        Validate.isTrue(config.option(SdkClientOption.SYNC_HTTP_CLIENT) == null || this.httpClientBuilder == null, "The httpClient and the httpClientBuilder can't both be configured.", new Object[0]);
        return Either.fromNullable(config.option(SdkClientOption.SYNC_HTTP_CLIENT), this.httpClientBuilder).map(e -> e.map(x$0 -> new NonManagedSdkHttpClient((SdkHttpClient)x$0), b -> b.buildWithDefaults(this.childHttpConfig(config)))).orElseGet(() -> this.defaultHttpClientBuilder.buildWithDefaults(this.childHttpConfig(config)));
    }

    private SdkAsyncHttpClient resolveAsyncHttpClient(SdkClientConfiguration config) {
        Validate.isTrue(config.option(SdkClientOption.ASYNC_HTTP_CLIENT) == null || this.asyncHttpClientBuilder == null, "The asyncHttpClient and the asyncHttpClientBuilder can't both be configured.", new Object[0]);
        return Either.fromNullable(config.option(SdkClientOption.ASYNC_HTTP_CLIENT), this.asyncHttpClientBuilder).map(e -> e.map(NonManagedSdkAsyncHttpClient::new, b -> b.buildWithDefaults(this.childHttpConfig(config)))).orElseGet(() -> this.defaultAsyncHttpClientBuilder.buildWithDefaults(this.childHttpConfig(config)));
    }

    protected AttributeMap childHttpConfig(SdkClientConfiguration configuration) {
        return this.childHttpConfig();
    }

    @Deprecated
    protected AttributeMap childHttpConfig() {
        return AttributeMap.empty();
    }

    private Executor resolveAsyncFutureCompletionExecutor(SdkClientConfiguration config) {
        Supplier<Executor> defaultExecutor = () -> {
            int processors = Runtime.getRuntime().availableProcessors();
            int corePoolSize = Math.max(8, processors);
            int maxPoolSize = Math.max(64, processors * 2);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("sdk-async-response").build());
            executor.allowCoreThreadTimeOut(true);
            return executor;
        };
        return Optional.ofNullable(config.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR)).orElseGet(defaultExecutor);
    }

    private ScheduledExecutorService resolveScheduledExecutorService() {
        return Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().threadNamePrefix("sdk-ScheduledExecutor").build());
    }

    private List<ExecutionInterceptor> resolveExecutionInterceptors(SdkClientConfiguration config) {
        ArrayList<ExecutionInterceptor> globalInterceptors = new ArrayList<ExecutionInterceptor>();
        globalInterceptors.addAll(this.sdkInterceptors());
        globalInterceptors.addAll(new ClasspathInterceptorChainFactory().getGlobalInterceptors());
        return CollectionUtils.mergeLists(globalInterceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
    }

    private List<ExecutionInterceptor> sdkInterceptors() {
        return Collections.unmodifiableList(Arrays.asList(new HttpChecksumRequiredInterceptor(), new SyncHttpChecksumInTrailerInterceptor(), new HttpChecksumValidationInterceptor(), new AsyncRequestBodyHttpChecksumTrailerInterceptor(), new HttpChecksumInHeaderInterceptor()));
    }

    @Override
    public final B endpointOverride(URI endpointOverride) {
        if (endpointOverride == null) {
            this.clientConfiguration.option(SdkClientOption.ENDPOINT, null);
            this.clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN, false);
        } else {
            Validate.paramNotNull(endpointOverride.getScheme(), "The URI scheme of endpointOverride");
            this.clientConfiguration.option(SdkClientOption.ENDPOINT, endpointOverride);
            this.clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN, true);
        }
        return this.thisBuilder();
    }

    public final void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride(endpointOverride);
    }

    public final B asyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
        this.clientConfiguration.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, asyncConfiguration.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR));
        return this.thisBuilder();
    }

    public final void setAsyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
        this.asyncConfiguration(asyncConfiguration);
    }

    @Override
    public final B overrideConfiguration(ClientOverrideConfiguration overrideConfig) {
        this.clientOverrideConfiguration = overrideConfig;
        return this.thisBuilder();
    }

    public final void setOverrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.overrideConfiguration(overrideConfiguration);
    }

    @Override
    public final ClientOverrideConfiguration overrideConfiguration() {
        if (this.clientOverrideConfiguration == null) {
            return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().build();
        }
        return this.clientOverrideConfiguration;
    }

    public final B httpClient(SdkHttpClient httpClient) {
        this.clientConfiguration.option(SdkClientOption.SYNC_HTTP_CLIENT, httpClient);
        return this.thisBuilder();
    }

    public final B httpClientBuilder(SdkHttpClient.Builder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this.thisBuilder();
    }

    public final B httpClient(SdkAsyncHttpClient httpClient) {
        this.clientConfiguration.option(SdkClientOption.ASYNC_HTTP_CLIENT, httpClient);
        return this.thisBuilder();
    }

    public final B httpClientBuilder(SdkAsyncHttpClient.Builder httpClientBuilder) {
        this.asyncHttpClientBuilder = httpClientBuilder;
        return this.thisBuilder();
    }

    public final B metricPublishers(List<MetricPublisher> metricPublishers) {
        this.clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS, metricPublishers);
        return this.thisBuilder();
    }

    protected B thisBuilder() {
        return (B)this;
    }

    @SdkTestInternalApi
    public static final class NonManagedSdkAsyncHttpClient
    implements SdkAsyncHttpClient {
        private final SdkAsyncHttpClient delegate;

        NonManagedSdkAsyncHttpClient(SdkAsyncHttpClient delegate) {
            this.delegate = Validate.paramNotNull(delegate, "SdkAsyncHttpClient");
        }

        @Override
        public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
            return this.delegate.execute(request);
        }

        @Override
        public String clientName() {
            return this.delegate.clientName();
        }

        @Override
        public void close() {
        }
    }

    @SdkTestInternalApi
    public static final class NonManagedSdkHttpClient
    implements SdkHttpClient {
        private final SdkHttpClient delegate;

        private NonManagedSdkHttpClient(SdkHttpClient delegate) {
            this.delegate = Validate.paramNotNull(delegate, "SdkHttpClient");
        }

        @Override
        public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
            return this.delegate.prepareRequest(request);
        }

        @Override
        public void close() {
        }

        @Override
        public String clientName() {
            return this.delegate.clientName();
        }
    }
}

