/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.kinesis.shaded.org.reactivestreams.Publisher;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.SdkHttpResponse;

@SdkInternalApi
public final class AsyncAfterTransmissionInterceptorCallingResponseHandler<T>
implements TransformingAsyncResponseHandler<T> {
    private final TransformingAsyncResponseHandler<T> delegate;
    private final ExecutionContext context;

    public AsyncAfterTransmissionInterceptorCallingResponseHandler(TransformingAsyncResponseHandler<T> delegate, ExecutionContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    private SdkHttpResponse beforeUnmarshalling(SdkHttpFullResponse response, ExecutionContext context) {
        InterceptorContext interceptorContext = (InterceptorContext)context.interceptorContext().copy(b -> b.httpResponse(response));
        context.interceptorChain().afterTransmission(interceptorContext, context.executionAttributes());
        interceptorContext = context.interceptorChain().modifyHttpResponse(interceptorContext, context.executionAttributes());
        context.interceptorChain().beforeUnmarshalling(interceptorContext, context.executionAttributes());
        context.interceptorContext(interceptorContext);
        return interceptorContext.httpResponse();
    }

    @Override
    public void onHeaders(SdkHttpResponse response) {
        this.delegate.onHeaders(this.beforeUnmarshalling((SdkHttpFullResponse)response, this.context));
    }

    @Override
    public void onError(Throwable error) {
        this.delegate.onError(error);
    }

    @Override
    public void onStream(Publisher<ByteBuffer> publisher) {
        Optional<Publisher<ByteBuffer>> newPublisher = this.context.interceptorChain().modifyAsyncHttpResponse(this.context.interceptorContext().toBuilder().responsePublisher(publisher).build(), this.context.executionAttributes()).responsePublisher();
        if (newPublisher.isPresent()) {
            this.delegate.onStream(newPublisher.get());
        } else {
            this.delegate.onStream(publisher);
        }
    }

    @Override
    public CompletableFuture<T> prepare() {
        return this.delegate.prepare();
    }
}

