/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.http.apache.internal;

import java.util.Set;
import software.amazon.kinesis.shaded.org.apache.http.HttpException;
import software.amazon.kinesis.shaded.org.apache.http.HttpHost;
import software.amazon.kinesis.shaded.org.apache.http.HttpRequest;
import software.amazon.kinesis.shaded.org.apache.http.impl.conn.DefaultRoutePlanner;
import software.amazon.kinesis.shaded.org.apache.http.impl.conn.DefaultSchemePortResolver;
import software.amazon.kinesis.shaded.org.apache.http.protocol.HttpContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private Set<String> hostPatterns;

    public SdkProxyRoutePlanner(String proxyHost, int proxyPort, String proxyProtocol, Set<String> nonProxyHosts) {
        super(DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(proxyHost, proxyPort, proxyProtocol);
        this.hostPatterns = nonProxyHosts;
    }

    private boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (this.hostPatterns == null) {
            return false;
        }
        String targetHost = StringUtils.lowerCase(target.getHostName());
        for (String pattern : this.hostPatterns) {
            if (!targetHost.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(target) ? null : this.proxy;
    }
}

