/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.http.nio.netty;

import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import software.amazon.kinesis.shaded.io.netty.channel.Channel;
import software.amazon.kinesis.shaded.io.netty.channel.ChannelFactory;
import software.amazon.kinesis.shaded.io.netty.channel.EventLoopGroup;
import software.amazon.kinesis.shaded.io.netty.channel.nio.NioEventLoopGroup;
import software.amazon.kinesis.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils.SocketChannelResolver;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class SdkEventLoopGroup {
    private final EventLoopGroup eventLoopGroup;
    private final ChannelFactory<? extends Channel> channelFactory;

    SdkEventLoopGroup(EventLoopGroup eventLoopGroup, ChannelFactory<? extends Channel> channelFactory) {
        Validate.paramNotNull(eventLoopGroup, "eventLoopGroup");
        Validate.paramNotNull(channelFactory, "channelFactory");
        this.eventLoopGroup = eventLoopGroup;
        this.channelFactory = channelFactory;
    }

    private SdkEventLoopGroup(DefaultBuilder builder) {
        this.eventLoopGroup = this.resolveEventLoopGroup(builder);
        this.channelFactory = this.resolveChannelFactory();
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public ChannelFactory<? extends Channel> channelFactory() {
        return this.channelFactory;
    }

    public static SdkEventLoopGroup create(EventLoopGroup eventLoopGroup, ChannelFactory<? extends Channel> channelFactory) {
        return new SdkEventLoopGroup(eventLoopGroup, channelFactory);
    }

    public static SdkEventLoopGroup create(EventLoopGroup eventLoopGroup) {
        return SdkEventLoopGroup.create(eventLoopGroup, SocketChannelResolver.resolveSocketChannelFactory(eventLoopGroup));
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private EventLoopGroup resolveEventLoopGroup(DefaultBuilder builder) {
        int numThreads = Optional.ofNullable(builder.numberOfThreads).orElse(0);
        ThreadFactory threadFactory = Optional.ofNullable(builder.threadFactory).orElseGet(() -> new ThreadFactoryBuilder().threadNamePrefix("aws-java-sdk-NettyEventLoop").build());
        return new NioEventLoopGroup(numThreads, threadFactory);
    }

    private ChannelFactory<? extends Channel> resolveChannelFactory() {
        return NioSocketChannel::new;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Integer numberOfThreads;
        private ThreadFactory threadFactory;

        private DefaultBuilder() {
        }

        @Override
        public Builder numberOfThreads(Integer numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public void setNumberOfThreads(Integer numberOfThreads) {
            this.numberOfThreads(numberOfThreads);
        }

        @Override
        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory(threadFactory);
        }

        @Override
        public SdkEventLoopGroup build() {
            return new SdkEventLoopGroup(this);
        }
    }

    public static interface Builder {
        public Builder numberOfThreads(Integer var1);

        public Builder threadFactory(ThreadFactory var1);

        public SdkEventLoopGroup build();
    }
}

