/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshaller;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerContext;
import software.amazon.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.XmlElement;

@SdkInternalApi
public final class MapQueryUnmarshaller
implements QueryUnmarshaller<Map<String, ?>> {
    @Override
    public Map<String, ?> unmarshall(QueryUnmarshallerContext context, List<XmlElement> content, SdkField<Map<String, ?>> field) {
        HashMap map = new HashMap();
        MapTrait mapTrait = field.getTrait(MapTrait.class);
        SdkField mapValueSdkField = mapTrait.valueFieldInfo();
        this.getEntries(content, mapTrait).forEach(entry -> {
            XmlElement key = entry.getElementByName(mapTrait.keyLocationName());
            XmlElement value = entry.getElementByName(mapTrait.valueLocationName());
            QueryUnmarshaller<Object> unmarshaller = context.getUnmarshaller(mapValueSdkField.location(), mapValueSdkField.marshallingType());
            map.put(key.textContent(), unmarshaller.unmarshall(context, Collections.singletonList(value), mapValueSdkField));
        });
        return map;
    }

    private List<XmlElement> getEntries(List<XmlElement> content, MapTrait mapTrait) {
        return mapTrait.isFlattened() ? content : content.get(0).getElementsByName("entry");
    }
}

