/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.TagMapCopier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddTagsToStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, AddTagsToStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(AddTagsToStreamRequest.getter(AddTagsToStreamRequest::streamName)).setter(AddTagsToStreamRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("Tags").getter(AddTagsToStreamRequest.getter(AddTagsToStreamRequest::tags)).setter(AddTagsToStreamRequest.setter(Builder::tags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, TAGS_FIELD));
    private final String streamName;
    private final Map<String, String> tags;

    private AddTagsToStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.tags = builder.tags;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToStreamRequest)) {
            return false;
        }
        AddTagsToStreamRequest other = (AddTagsToStreamRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder("AddTagsToStreamRequest").add("StreamName", this.streamName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddTagsToStreamRequest, T> g) {
        return obj -> g.apply((AddTagsToStreamRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToStreamRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.tags(model.tags);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddTagsToStreamRequest build() {
            return new AddTagsToStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddTagsToStreamRequest> {
        public Builder streamName(String var1);

        public Builder tags(Map<String, String> var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

