/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.Tag;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.TagListCopier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForStreamResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, ListTagsForStreamResponse> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Tags").getter(ListTagsForStreamResponse.getter(ListTagsForStreamResponse::tags)).setter(ListTagsForStreamResponse.setter(Builder::tags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(Tag::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Boolean> HAS_MORE_TAGS_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("HasMoreTags").getter(ListTagsForStreamResponse.getter(ListTagsForStreamResponse::hasMoreTags)).setter(ListTagsForStreamResponse.setter(Builder::hasMoreTags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreTags").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, HAS_MORE_TAGS_FIELD));
    private final List<Tag> tags;
    private final Boolean hasMoreTags;

    private ListTagsForStreamResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.hasMoreTags = builder.hasMoreTags;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean hasMoreTags() {
        return this.hasMoreTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResponse)) {
            return false;
        }
        ListTagsForStreamResponse other = (ListTagsForStreamResponse)obj;
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.hasMoreTags(), other.hasMoreTags());
    }

    public final String toString() {
        return ToString.builder("ListTagsForStreamResponse").add("Tags", this.hasTags() ? this.tags() : null).add("HasMoreTags", this.hasMoreTags()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "HasMoreTags": {
                return Optional.ofNullable(clazz.cast(this.hasMoreTags()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForStreamResponse, T> g) {
        return obj -> g.apply((ListTagsForStreamResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasMoreTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamResponse model) {
            super(model);
            this.tags(model.tags);
            this.hasMoreTags(model.hasMoreTags);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getHasMoreTags() {
            return this.hasMoreTags;
        }

        public final void setHasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
        }

        @Override
        public final Builder hasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
            return this;
        }

        @Override
        public ListTagsForStreamResponse build() {
            return new ListTagsForStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsForStreamResponse> {
        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder hasMoreTags(Boolean var1);
    }
}

