/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricsName {
    INCOMING_BYTES("IncomingBytes"),
    INCOMING_RECORDS("IncomingRecords"),
    OUTGOING_BYTES("OutgoingBytes"),
    OUTGOING_RECORDS("OutgoingRecords"),
    WRITE_PROVISIONED_THROUGHPUT_EXCEEDED("WriteProvisionedThroughputExceeded"),
    READ_PROVISIONED_THROUGHPUT_EXCEEDED("ReadProvisionedThroughputExceeded"),
    ITERATOR_AGE_MILLISECONDS("IteratorAgeMilliseconds"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricsName> VALUE_MAP;
    private final String value;

    private MetricsName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricsName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricsName> knownValues() {
        EnumSet<MetricsName> knownValues = EnumSet.allOf(MetricsName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricsName.class, MetricsName::toString);
    }
}

