/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ShardFilterType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShardFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShardFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Type").getter(ShardFilter.getter(ShardFilter::typeAsString)).setter(ShardFilter.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ShardId").getter(ShardFilter.getter(ShardFilter::shardId)).setter(ShardFilter.setter(Builder::shardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("Timestamp").getter(ShardFilter.getter(ShardFilter::timestamp)).setter(ShardFilter.setter(Builder::timestamp)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SHARD_ID_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String shardId;
    private final Instant timestamp;

    private ShardFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.shardId = builder.shardId;
        this.timestamp = builder.timestamp;
    }

    public final ShardFilterType type() {
        return ShardFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardFilter)) {
            return false;
        }
        ShardFilter other = (ShardFilter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder("ShardFilter").add("Type", this.typeAsString()).add("ShardId", this.shardId()).add("Timestamp", this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShardFilter, T> g) {
        return obj -> g.apply((ShardFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String shardId;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardFilter model) {
            this.type(model.type);
            this.shardId(model.shardId);
            this.timestamp(model.timestamp);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShardFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ShardFilter build() {
            return new ShardFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShardFilter> {
        public Builder type(String var1);

        public Builder type(ShardFilterType var1);

        public Builder shardId(String var1);

        public Builder timestamp(Instant var1);
    }
}

