/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShardIteratorType {
    AT_SEQUENCE_NUMBER("AT_SEQUENCE_NUMBER"),
    AFTER_SEQUENCE_NUMBER("AFTER_SEQUENCE_NUMBER"),
    TRIM_HORIZON("TRIM_HORIZON"),
    LATEST("LATEST"),
    AT_TIMESTAMP("AT_TIMESTAMP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShardIteratorType> VALUE_MAP;
    private final String value;

    private ShardIteratorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShardIteratorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShardIteratorType> knownValues() {
        EnumSet<ShardIteratorType> knownValues = EnumSet.allOf(ShardIteratorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShardIteratorType.class, ShardIteratorType::toString);
    }
}

