/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import software.amazon.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public final class StsAssumeRoleCredentialsProvider
extends StsCredentialsProvider
implements ToCopyableBuilder<Builder, StsAssumeRoleCredentialsProvider> {
    private Supplier<AssumeRoleRequest> assumeRoleRequestSupplier;

    private StsAssumeRoleCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-credentials-provider");
        Validate.notNull(builder.assumeRoleRequestSupplier, "Assume role request must not be null.", new Object[0]);
        this.assumeRoleRequestSupplier = builder.assumeRoleRequestSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        AssumeRoleRequest assumeRoleRequest = this.assumeRoleRequestSupplier.get();
        Validate.notNull(assumeRoleRequest, "Assume role request must not be null.", new Object[0]);
        return stsClient.assumeRole(assumeRoleRequest).credentials();
    }

    public String toString() {
        return ToString.builder("StsAssumeRoleCredentialsProvider").add("refreshRequest", this.assumeRoleRequestSupplier).build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleCredentialsProvider> {
        private Supplier<AssumeRoleRequest> assumeRoleRequestSupplier;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleCredentialsProvider((Builder)x$0));
        }

        private Builder(StsAssumeRoleCredentialsProvider provider) {
            super((B x$0) -> new StsAssumeRoleCredentialsProvider((Builder)x$0), provider);
            this.assumeRoleRequestSupplier = provider.assumeRoleRequestSupplier;
        }

        public Builder refreshRequest(AssumeRoleRequest assumeRoleRequest) {
            return this.refreshRequest(() -> assumeRoleRequest);
        }

        public Builder refreshRequest(Supplier<AssumeRoleRequest> assumeRoleRequestSupplier) {
            this.assumeRoleRequestSupplier = assumeRoleRequestSupplier;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleRequest.Builder> assumeRoleRequest) {
            return this.refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().applyMutation(assumeRoleRequest).build());
        }

        @Override
        public StsAssumeRoleCredentialsProvider build() {
            return (StsAssumeRoleCredentialsProvider)super.build();
        }
    }
}

