/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.batch.builder;

import com.amazonaws.services.lambda.runtime.Context;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import software.amazon.lambda.powertools.batch.handler.BatchMessageHandler;

abstract class AbstractBatchMessageHandlerBuilder<T, C, E, R> {
    protected BiConsumer<T, Throwable> failureHandler;
    protected Consumer<T> successHandler;

    AbstractBatchMessageHandlerBuilder() {
    }

    public C withSuccessHandler(Consumer<T> handler) {
        this.successHandler = handler;
        return this.getThis();
    }

    public C withFailureHandler(BiConsumer<T, Throwable> handler) {
        this.failureHandler = handler;
        return this.getThis();
    }

    public abstract BatchMessageHandler<E, R> buildWithRawMessageHandler(BiConsumer<T, Context> var1);

    public BatchMessageHandler<E, R> buildWithRawMessageHandler(Consumer<T> handler) {
        return this.buildWithRawMessageHandler((T f, Context c) -> handler.accept(f));
    }

    public abstract <M> BatchMessageHandler<E, R> buildWithMessageHandler(BiConsumer<M, Context> var1, Class<M> var2);

    public <M> BatchMessageHandler<E, R> buildWithMessageHandler(Consumer<M> handler, Class<M> messageClass) {
        return this.buildWithMessageHandler((M f, Context c) -> handler.accept(f), messageClass);
    }

    protected abstract C getThis();
}

