/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.batch.handler;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.StreamsEventResponse;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.batch.handler.BatchMessageHandler;

public class DynamoDbBatchMessageHandler
implements BatchMessageHandler<DynamodbEvent, StreamsEventResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDbBatchMessageHandler.class);
    private final Consumer<DynamodbEvent.DynamodbStreamRecord> successHandler;
    private final BiConsumer<DynamodbEvent.DynamodbStreamRecord, Throwable> failureHandler;
    private final BiConsumer<DynamodbEvent.DynamodbStreamRecord, Context> rawMessageHandler;

    public DynamoDbBatchMessageHandler(Consumer<DynamodbEvent.DynamodbStreamRecord> successHandler, BiConsumer<DynamodbEvent.DynamodbStreamRecord, Throwable> failureHandler, BiConsumer<DynamodbEvent.DynamodbStreamRecord, Context> rawMessageHandler) {
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
        this.rawMessageHandler = rawMessageHandler;
    }

    @Override
    public StreamsEventResponse processBatch(DynamodbEvent event, Context context) {
        ArrayList<StreamsEventResponse.BatchItemFailure> batchFailures = new ArrayList<StreamsEventResponse.BatchItemFailure>();
        for (DynamodbEvent.DynamodbStreamRecord record : event.getRecords()) {
            try {
                this.rawMessageHandler.accept(record, context);
                if (this.successHandler == null) continue;
                this.successHandler.accept(record);
            }
            catch (Throwable t) {
                String sequenceNumber = record.getDynamodb().getSequenceNumber();
                LOGGER.error("Error while processing record with id {}: {}, adding it to batch item failures", (Object)sequenceNumber, (Object)t.getMessage());
                LOGGER.error("Error was", t);
                batchFailures.add(new StreamsEventResponse.BatchItemFailure(sequenceNumber));
                if (this.failureHandler == null) continue;
                try {
                    this.failureHandler.accept(record, t);
                }
                catch (Throwable t2) {
                    LOGGER.warn("failureHandler threw handling failure", t2);
                }
            }
        }
        return new StreamsEventResponse(batchFailures);
    }
}

